﻿
SET NOCOUNT ON 
 GO 
  IF OBJECT_ID('TEMPDB.DBO.#TA') IS NOT NULL DROP TABLE #TA 
 GO 
 
 SELECT CGX6_CODICE, CGX6_NOME, CGX6_XSD INTO #tA FROM CGX6_SCHEMAXSD WHERE 1=0 
 
 insert #tA values ('1', 'fornituraIvp_2017_v1', '<?xml version="1.0" encoding="UTF-8"?>
<!-- edited with XMLSpy v2017 sp2 (x64) (http://www.altova.com) by rsiino 
	(Sogei S.p.A.) -->
<xs:schema xmlns:xs="http://www.w3.org/2001/XMLSchema"
	xmlns:cm="urn:www.agenziaentrate.gov.it:specificheTecniche:common"
	xmlns:sc="urn:www.agenziaentrate.gov.it:specificheTecniche:sco:common"
	xmlns:iv="urn:www.agenziaentrate.gov.it:specificheTecniche:sco:ivp"
	xmlns:ds="http://www.w3.org/2000/09/xmldsig#"
	targetNamespace="urn:www.agenziaentrate.gov.it:specificheTecniche:sco:ivp"
	elementFormDefault="qualified" attributeFormDefault="unqualified"
	version="1.0">
	
	<xs:import namespace="http://www.w3.org/2000/09/xmldsig#" schemaLocation="http://www.w3.org/TR/2002/REC-xmldsig-core-20020212/xmldsig-core-schema.xsd" />
	
	<xs:annotation>
		<xs:documentation xml:lang="it"><![CDATA[
		Versione 1.0 - 13/02/16
		]]></xs:documentation>
	</xs:annotation>
	<xs:include schemaLocation="intestazioneIvp_2017_v1.xsd" />
	<xs:include schemaLocation="comunicazioneIvp_2017_v1.xsd" />
	<xs:element name="Fornitura">
		<xs:complexType>
			<xs:sequence>
				<xs:element name="Intestazione" type="iv:Intestazione_IVP_Type" />
				<xs:element name="Comunicazione" type="iv:Comunicazione_IVP_Type" />
				<xs:element ref="ds:Signature" minOccurs="0" />
			</xs:sequence>
		</xs:complexType>
	</xs:element>
</xs:schema>
')
 insert #tA values ('2', 'intestazioneIvp_2017_v1', '<?xml version="1.0" encoding="UTF-8"?>
<!-- edited with XMLSpy v2017 sp2 (x64) (http://www.altova.com) by rsiino (Sogei S.p.A.) -->
<xs:schema xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:cm="urn:www.agenziaentrate.gov.it:specificheTecniche:common" xmlns:sc="urn:www.agenziaentrate.gov.it:specificheTecniche:sco:common" xmlns:iv="urn:www.agenziaentrate.gov.it:specificheTecniche:sco:ivp" xmlns:ns1="www.agenziaentrate.gov.it:specificheTecniche:telent:v1" targetNamespace="urn:www.agenziaentrate.gov.it:specificheTecniche:sco:ivp" elementFormDefault="qualified" attributeFormDefault="unqualified" version="1.0">
	<xs:annotation>
		<xs:documentation xml:lang="it"><![CDATA[
		Versione 1.0 - 13/02/16
		]]></xs:documentation>
	</xs:annotation>
	<xs:import namespace="urn:www.agenziaentrate.gov.it:specificheTecniche:common" schemaLocation="../../common/fornitura_v3.xsd"/>
	<xs:element name="Intestazione"/>
	<xs:complexType name="Intestazione_IVP_Type">
		<xs:sequence>
			<xs:element name="CodiceFornitura">
				<xs:simpleType>
					<xs:restriction base="cm:DatoAN_Type">
						<xs:enumeration value="IVP17"/>
					</xs:restriction>
				</xs:simpleType>
			</xs:element>
			<xs:element name="CodiceFiscaleDichiarante" type="cm:DatoCF_Type" minOccurs="0"/>
			<xs:element name="CodiceCarica" minOccurs="0">
				<xs:simpleType>
					<xs:restriction base="cm:DatoNP_Type">
						<xs:enumeration value="1"/>
						<xs:enumeration value="2"/>
						<xs:enumeration value="3"/>
						<xs:enumeration value="4"/>
						<xs:enumeration value="5"/>
						<xs:enumeration value="6"/>
						<xs:enumeration value="7"/>
						<xs:enumeration value="8"/>
						<xs:enumeration value="9"/>
						<xs:enumeration value="11"/>
						<xs:enumeration value="12"/>
						<xs:enumeration value="13"/>
						<xs:enumeration value="14"/>
						<xs:enumeration value="15"/>
					</xs:restriction>
				</xs:simpleType>
			</xs:element>
			<xs:element name="IdSistema" type="cm:DatoCF_Type" minOccurs="0"/>
		</xs:sequence>
	</xs:complexType>
</xs:schema>
')
 insert #tA values ('3', 'comunicazioneIvp_2017_v1', '<?xml version="1.0" encoding="UTF-8"?>
<!-- edited with XMLSpy v2017 sp2 (x64) (http://www.altova.com) by rsiino (Sogei S.p.A.) -->
<xs:schema xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:cm="urn:www.agenziaentrate.gov.it:specificheTecniche:common" xmlns:sc="urn:www.agenziaentrate.gov.it:specificheTecniche:sco:common" xmlns:iv="urn:www.agenziaentrate.gov.it:specificheTecniche:sco:ivp" xmlns:ns1="www.agenziaentrate.gov.it:specificheTecniche:telent:v1" targetNamespace="urn:www.agenziaentrate.gov.it:specificheTecniche:sco:ivp" elementFormDefault="qualified" attributeFormDefault="unqualified" version="1.0">
	<xs:annotation>
		<xs:documentation xml:lang="it"><![CDATA[
		Versione 1.0 - 13/02/16]]></xs:documentation>
	</xs:annotation>
	<xs:import namespace="urn:www.agenziaentrate.gov.it:specificheTecniche:common" schemaLocation="../../common/fornitura_v3.xsd"/>
	<xs:element name="Comunicazione" type="iv:Comunicazione_IVP_Type"/>
	<xs:complexType name="Comunicazione_IVP_Type">
		<xs:complexContent>
			<xs:extension base="cm:Documento_Type">
				<xs:sequence>
					<xs:element name="Frontespizio" type="iv:Frontespizio_IVP_Type"/>
					<xs:element name="DatiContabili" type="iv:DatiContabili_IVP_Type"/>
				</xs:sequence>
			</xs:extension>
		</xs:complexContent>
	</xs:complexType>
	<xs:complexType name="Frontespizio_IVP_Type">
		<xs:sequence>
			<xs:element name="CodiceFiscale" type="cm:DatoCF_Type"/>
			<xs:element name="AnnoImposta" type="cm:DatoDA_Type"/>
			<xs:element name="PartitaIVA" type="cm:DatoPI_Type"/>
			<xs:element name="PIVAControllante" type="cm:DatoPI_Type" minOccurs="0"/>
			<xs:element name="UltimoMese" minOccurs="0">
				<xs:simpleType>
					<xs:restriction base="cm:DatoNP_Type">
						<xs:enumeration value="1"/>
						<xs:enumeration value="2"/>
						<xs:enumeration value="3"/>
						<xs:enumeration value="4"/>
						<xs:enumeration value="5"/>
						<xs:enumeration value="6"/>
						<xs:enumeration value="7"/>
						<xs:enumeration value="8"/>
						<xs:enumeration value="9"/>
						<xs:enumeration value="10"/>
						<xs:enumeration value="11"/>
						<xs:enumeration value="12"/>
						<xs:enumeration value="13"/>
						<xs:enumeration value="99"/>
					</xs:restriction>
				</xs:simpleType>
			</xs:element>
			<xs:element name="LiquidazioneGruppo" type="cm:DatoCB_Type" minOccurs="0"/>
			<xs:element name="CFDichiarante" type="cm:DatoCF_Type" minOccurs="0"/>
			<xs:element name="CodiceCaricaDichiarante" minOccurs="0">
				<xs:simpleType>
					<xs:restriction base="cm:DatoNP_Type">
						<xs:enumeration value="1"/>
						<xs:enumeration value="2"/>
						<xs:enumeration value="3"/>
						<xs:enumeration value="4"/>
						<xs:enumeration value="5"/>
						<xs:enumeration value="6"/>
						<xs:enumeration value="7"/>
						<xs:enumeration value="8"/>
						<xs:enumeration value="9"/>
						<xs:enumeration value="11"/>
						<xs:enumeration value="12"/>
						<xs:enumeration value="13"/>
						<xs:enumeration value="14"/>
						<xs:enumeration value="15"/>
					</xs:restriction>
				</xs:simpleType>
			</xs:element>
			<xs:element name="CodiceFiscaleSocieta" type="cm:DatoCN_Type" minOccurs="0"/>
			<xs:element name="FirmaDichiarazione" type="cm:DatoCB_Type"/>
			<xs:element name="CFIntermediario" type="cm:DatoCF_Type" minOccurs="0"/>
			<xs:element name="ImpegnoPresentazione" minOccurs="0">
				<xs:simpleType>
					<xs:restriction base="cm:DatoN1_Type">
						<xs:enumeration value="1"/>
						<xs:enumeration value="2"/>
					</xs:restriction>
				</xs:simpleType>
			</xs:element>
			<xs:element name="DataImpegno" type="cm:DatoDT_Type" minOccurs="0"/>
			<xs:element name="FirmaIntermediario" type="cm:DatoCB_Type" minOccurs="0"/>
			<xs:element name="FlagConferma" type="cm:DatoCB_Type" minOccurs="0"/>
			<xs:element name="IdentificativoProdSoftware" type="cm:DatoAN_Type" minOccurs="0"/>
		</xs:sequence>
	</xs:complexType>
	<xs:complexType name="DatiContabili_IVP_Type">
		<xs:sequence>
			<xs:element name="Modulo" maxOccurs="5">
				<xs:complexType>
					<xs:sequence>
						<xs:element name="Mese" minOccurs="0">
							<xs:simpleType>
								<xs:restriction base="cm:DatoNP_Type">
									<xs:enumeration value="1"/>
									<xs:enumeration value="2"/>
									<xs:enumeration value="3"/>
									<xs:enumeration value="4"/>
									<xs:enumeration value="5"/>
									<xs:enumeration value="6"/>
									<xs:enumeration value="7"/>
									<xs:enumeration value="8"/>
									<xs:enumeration value="9"/>
									<xs:enumeration value="10"/>
									<xs:enumeration value="11"/>
									<xs:enumeration value="12"/>
								</xs:restriction>
							</xs:simpleType>
						</xs:element>
						<xs:element name="Trimestre" minOccurs="0">
							<xs:simpleType>
								<xs:restriction base="cm:DatoN1_Type">
									<xs:enumeration value="1"/>
									<xs:enumeration value="2"/>
									<xs:enumeration value="3"/>
									<xs:enumeration value="4"/>
									<xs:enumeration value="5"/>
								</xs:restriction>
							</xs:simpleType>
						</xs:element>
						<xs:element name="Subfornitura" type="cm:DatoCB_Type" minOccurs="0"/>
						<xs:element name="EventiEccezionali" type="iv:Eventi_Ecc_Type" minOccurs="0"/>
						<xs:element name="TotaleOperazioniAttive" type="iv:DatoVN_Type" minOccurs="0"/>
						<xs:element name="TotaleOperazioniPassive" type="iv:DatoVN_Type" minOccurs="0"/>
						<xs:element name="IvaEsigibile" type="iv:DatoVN_Type" minOccurs="0"/>
						<xs:element name="IvaDetratta" type="iv:DatoVN_Type" minOccurs="0"/>
						<xs:element name="IvaDovuta" type="cm:DatoVP_Type" minOccurs="0"/>
						<xs:element name="IvaCredito" type="cm:DatoVP_Type" minOccurs="0"/>
						<xs:element name="DebitoPrecedente" type="cm:DatoVP_Type" minOccurs="0"/>
						<xs:element name="CreditoPeriodoPrecedente" type="cm:DatoVP_Type" minOccurs="0"/>
						<xs:element name="CreditoAnnoPrecedente" type="iv:DatoVN_Type" minOccurs="0"/>
						<xs:element name="VersamentiAutoUE" type="cm:DatoVP_Type" minOccurs="0"/>
						<xs:element name="CreditiImposta" type="cm:DatoVP_Type" minOccurs="0"/>
						<xs:element name="InteressiDovuti" type="cm:DatoVP_Type" minOccurs="0"/>
						<xs:element name="Acconto" type="cm:DatoVP_Type" minOccurs="0"/>
						<xs:element name="ImportoDaVersare" type="cm:DatoVP_Type" minOccurs="0"/>
						<xs:element name="ImportoACredito" type="cm:DatoVP_Type" minOccurs="0"/>
					</xs:sequence>
				</xs:complexType>
			</xs:element>
		</xs:sequence>
	</xs:complexType>
	<xs:simpleType name="Eventi_Ecc_Type">
		<xs:restriction base="xs:string">
			<xs:enumeration value="1"/>
			<xs:enumeration value="9"/>
		</xs:restriction>
	</xs:simpleType>
	<xs:simpleType name="DatoVN_Type">
		<xs:annotation>
			<xs:documentation>Tipo semplice che identifica numeri positivi con 2 cifre decimali. La lunghezza massima prevista è di 16 caratteri, il separatore decimale previsto è la virgola.</xs:documentation>
		</xs:annotation>
		<xs:restriction base="xs:string">
			<xs:maxLength value="16"/>
			<xs:pattern value="[\-]{0,1}[0-9]+,[0-9]{2}"/>
		</xs:restriction>
	</xs:simpleType>
</xs:schema>
')
 insert #tA values ('4', 'fornitura_v3', '<?xml version="1.0" encoding="UTF-8"?>
<xs:schema xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns="urn:www.agenziaentrate.gov.it:specificheTecniche:common" targetNamespace="urn:www.agenziaentrate.gov.it:specificheTecniche:common" elementFormDefault="qualified" attributeFormDefault="unqualified" version="3.0">
	<xs:annotation>
		<xs:documentation xml:lang="it"><![CDATA[
		Versione 3.0 - 10/12/13
		- modificato import typesDati_v3.xsd
		- modificato targetNamespace
		
		Versione 2.1 - 10/07/13
		- rimossi gli elementi complessi Fornitura e Intestazione 

		Versione 2.0 - 15/02/12
		- modificato il tipo Intestazione_Type: introdotto il tipo complesso Dati_Intestazione_Type
		- modificato il tipo Codice_Fornitura_Type
		- modificato l''elemento TipoFornitore: associato il type DatoNP_Type
		- modificato targetNamespace
		]]></xs:documentation>
	</xs:annotation>
	<xs:include schemaLocation="typesDati_v3.xsd"/>
	<xs:element name="Documento" type="Documento_Type" abstract="true"/>
	<xs:complexType name="Documento_Type">
		<xs:annotation>
			<xs:documentation xml:lang="it">Documento trasmesso</xs:documentation>
		</xs:annotation>
		<xs:attribute name="identificativo" type="Identificativo_Type" use="required"/>
	</xs:complexType>
	<xs:simpleType name="Identificativo_Type">
		<xs:restriction base="xs:string">
			<xs:pattern value="[0-9]{4}[1-9]|[0-9]{3}[1-9][0-9]|[0-9]{2}[1-9][0-9]{2}|[0-9][1-9][0-9]{3}|[1-9][0-9]{4}"/>
		</xs:restriction>
	</xs:simpleType>
</xs:schema>
')
 insert #tA values ('5', 'typesDati_v3', '<?xml version="1.0" encoding="UTF-8"?>
<xs:schema xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns="urn:www.agenziaentrate.gov.it:specificheTecniche:common" targetNamespace="urn:www.agenziaentrate.gov.it:specificheTecniche:common" elementFormDefault="qualified" attributeFormDefault="unqualified" version="3.0">
	<xs:annotation>
		<xs:documentation xml:lang="it"><![CDATA[
		Versione 3.0 - 10/12/13
		- modificato targetNamespace
		Versione 2.0.1 - 14/06/12
		- modificati i tipi semplici DatoAN_Type, DatoEM_Type
		Versione 2.0 - 15/02/12
		- modificato targetNamespace
		- introdotti i tipi semplici DatoGA_Type, DatoTL_Type, DatoCP_Type
		]]></xs:documentation>
	</xs:annotation>
	<xs:include schemaLocation="typesProvincie_v3.xsd"/>
	<xs:simpleType name="DatoAN_Type">
		<xs:annotation>
			<xs:documentation>Tipo semplice costituito da caratteri alfanumerici maiuscoli e dai caratteri: punto, virgola, apice, trattino, spazio, barra semplice, °, ^, ampersand, parentesi aperta e chiusa, doppie virgolette, barra rovesciata, la barra dritta, il più, le maiuscole accentate e la Ü. Tali caratteri non sono ammesi come primo carattere tranne: i numeri da 0 a 9, i caratteri maiuscoli da A a Z, il meno e le dopppie virgolette.</xs:documentation>
		</xs:annotation>
		<xs:restriction base="xs:string">
			<xs:pattern value="([0-9A-Z\-]|&quot;){1}([ 0-9A-Z&amp;]|''|\-|\.|,|/|°|\^|\(|\)|À|È|É|Ì|Ò|Ù|Ü|&quot;|\\|\||\+)*"/>
		</xs:restriction>
	</xs:simpleType>
	<xs:simpleType name="DatoNU_Type">
		<xs:annotation>
			<xs:documentation>Tipo semplice che identifica numeri naturali positivi e negativi con al massimo 16 cifre.</xs:documentation>
		</xs:annotation>
		<xs:restriction base="xs:string">
			<xs:maxLength value="16"/>
			<xs:pattern value="(\-[1-9]|[1-9])[0-9]*"/>
		</xs:restriction>
	</xs:simpleType>
	<xs:simpleType name="DatoPC_Type">
		<xs:annotation>
			<xs:documentation>Tipo semplice che esprime una percentuale e dunque consente valori positivi non superiori a 100, con al massimo 2 cifre decimali. Il separatore decimale previsto è la virgola.</xs:documentation>
		</xs:annotation>
		<xs:restriction base="xs:string">
			<xs:maxLength value="16"/>
			<xs:pattern value="[0-9]?[0-9](,\d{1,3})?|100(,0{1,3})?"/>
		</xs:restriction>
	</xs:simpleType>
	<xs:simpleType name="DatoQU_Type">
		<xs:annotation>
			<xs:documentation>Tipo semplice che identifica numeri positivi con al massimo 5 cifre decimali. La lunghezza massima prevista è di 16 caratteri, il separatore decimale previsto è la virgola.</xs:documentation>
		</xs:annotation>
		<xs:restriction base="xs:string">
			<xs:maxLength value="16"/>
			<xs:pattern value="[0-9]+(,[0-9]{1,5})?"/>
		</xs:restriction>
	</xs:simpleType>
	<xs:simpleType name="DatoVP_Type">
		<xs:annotation>
			<xs:documentation>Tipo semplice che identifica numeri positivi con 2 cifre decimali. La lunghezza massima prevista è di 16 caratteri, il separatore decimale previsto è la virgola.</xs:documentation>
		</xs:annotation>
		<xs:restriction base="xs:string">
			<xs:maxLength value="16"/>
			<xs:pattern value="[0-9]+,[0-9]{2}"/>
		</xs:restriction>
	</xs:simpleType>
	<xs:simpleType name="DatoN1_Type">
		<xs:annotation>
			<xs:documentation>Tipo semplice che identifica i numeri naturali da 1 a 9.</xs:documentation>
		</xs:annotation>
		<xs:restriction base="xs:string">
			<xs:maxLength value="1"/>
			<xs:pattern value="[1-9]"/>
		</xs:restriction>
	</xs:simpleType>
	<xs:simpleType name="DatoNP_Type">
		<xs:annotation>
			<xs:documentation>Tipo semplice che identifica numeri naturali positivi con al massimo 16 cifre.</xs:documentation>
		</xs:annotation>
		<xs:restriction base="xs:string">
			<xs:pattern value="[1-9]{1}[0-9]*"/>
		</xs:restriction>
	</xs:simpleType>
	<xs:simpleType name="DatoPI_Type">
		<xs:annotation>
			<xs:documentation>Tipo semplice che identifica la partita IVA rispettandone i vincoli di struttura. </xs:documentation>
		</xs:annotation>
		<xs:restriction base="xs:string">
			<xs:length value="11"/>
			<xs:pattern value="[0-7][0-9]{10}"/>
		</xs:restriction>
	</xs:simpleType>
	<xs:simpleType name="DatoCN_Type">
		<xs:annotation>
			<xs:documentation>Tipo semplice che identifica un codice fiscale numerico rispettandone i vincoli di struttura.</xs:documentation>
		</xs:annotation>
		<xs:restriction base="xs:string">
			<xs:length value="11"/>
			<xs:pattern value="[0-9]{11}"/>
		</xs:restriction>
	</xs:simpleType>
	<xs:simpleType name="DatoCF_Type">
		<xs:annotation>
			<xs:documentation>Tipo semplice che identifica un codice fiscale provvisorio o alfanumerico rispettandone i vincoli di struttura.</xs:documentation>
		</xs:annotation>
		<xs:restriction base="xs:string">
			<xs:pattern value="[0-9]{11}|[A-Z]{6}[0-9LMNPQRSTUV]{2}[A-Z]{1}[0-9LMNPQRSTUV]{2}[A-Z]{1}[0-9LMNPQRSTUV]{3}[A-Z]{1}"/>
		</xs:restriction>
	</xs:simpleType>
	<xs:simpleType name="DatoCB_Type">
		<xs:annotation>
			<xs:documentation>Tipo semplice che consente esclusivamente i valori 0 e 1.</xs:documentation>
		</xs:annotation>
		<xs:restriction base="xs:byte">
			<xs:pattern value="[01]"/>
		</xs:restriction>
	</xs:simpleType>
	<xs:simpleType name="DatoCB12_Type">
		<xs:annotation>
			<xs:documentation>Tipo semplice che consente esclusivamente 12 caratteri con i valori 0 e 1.</xs:documentation>
		</xs:annotation>
		<xs:restriction base="xs:byte">
			<xs:pattern value="[10]{12}"/>
		</xs:restriction>
	</xs:simpleType>
	<xs:simpleType name="DatoDT_Type">
		<xs:annotation>
			<xs:documentation>Tipo semplice che identifica una data nel formato ggmmaaaa. La data indicata non deve essere successiva alla data corrente.</xs:documentation>
		</xs:annotation>
		<xs:restriction base="xs:string">
			<xs:length value="8"/>
			<xs:pattern value="(((0[1-9]|[12][0-9]|3[01])(0[13578]|10|12)(\d{4}))|(([0][1-9]|[12][0-9]|30)(0[469]|11)(\d{4}))|((0[1-9]|1[0-9]|2[0-8])(02)(\d{4}))|((29)(02)([02468][048]00))|((29)(02)([13579][26]00))|((29)(02)([0-9][0-9][0][48]))|((29)(02)([0-9][0-9][2468][048]))|((29)(02)([0-9][0-9][13579][26])))"/>
		</xs:restriction>
	</xs:simpleType>
	<xs:simpleType name="DatoDA_Type">
		<xs:annotation>
			<xs:documentation>Tipo semplice che identifica un anno nel formato aaaa. Sono ammessi anni dal 1800 al 2099.</xs:documentation>
		</xs:annotation>
		<xs:restriction base="xs:string">
			<xs:length value="4"/>
			<xs:pattern value="(18|19|20)[0-9]{2}"/>
		</xs:restriction>
	</xs:simpleType>
	<xs:simpleType name="DatoDN_Type">
		<xs:annotation>
			<xs:documentation>Tipo semplice che identifica una data nel formato ggmmaaaa.</xs:documentation>
		</xs:annotation>
		<xs:restriction base="xs:string">
			<xs:length value="8"/>
			<xs:pattern value="(((0[1-9]|[12][0-9]|3[01])(0[13578]|10|12)(\d{4}))|(([0][1-9]|[12][0-9]|30)(0[469]|11)(\d{4}))|((0[1-9]|1[0-9]|2[0-8])(02)(\d{4}))|((29)(02)([02468][048]00))|((29)(02)([13579][26]00))|((29)(02)([0-9][0-9][0][48]))|((29)(02)([0-9][0-9][2468][048]))|((29)(02)([0-9][0-9][13579][26])))"/>
		</xs:restriction>
	</xs:simpleType>
	<xs:simpleType name="DatoD6_Type">
		<xs:annotation>
			<xs:documentation>Tipo semplice che identifica una data nel formato mmaaaa.</xs:documentation>
		</xs:annotation>
		<xs:restriction base="xs:string">
			<xs:length value="6"/>
			<xs:pattern value="((0[0-9])|(1[0-2]))((19|20)[0-9][0-9])"/>
		</xs:restriction>
	</xs:simpleType>
	<xs:simpleType name="DatoEM_Type">
		<xs:annotation>
			<xs:documentation>Tipo semplice che identifica un elemento di tipo email</xs:documentation>
		</xs:annotation>
		<xs:restriction base="xs:string">
			<xs:pattern value="[a-zA-Z0-9._%\-''&quot;?^~=]+@[a-zA-Z0-9.\-]+\.[a-zA-Z]{2,4}"/>
		</xs:restriction>
	</xs:simpleType>
	<xs:simpleType name="DatoGA_Type">
		<xs:annotation>
			<xs:documentation>Tipo semplice che identifica il numero di giorni in un anno e va da 1 a 365</xs:documentation>
		</xs:annotation>
		<xs:restriction base="xs:string">
			<xs:minLength value="1"/>
			<xs:maxLength value="3"/>
			<xs:pattern value="[1-9]|([1-9][0-9])|([12][0-9][0-9])|(3[0-5][0-9])|(36[0-5])"/>
		</xs:restriction>
	</xs:simpleType>
	<xs:simpleType name="DatoTL_Type">
		<xs:annotation>
			<xs:documentation>Tipo semplice che identifica un elemento di tipo telefono</xs:documentation>
		</xs:annotation>
		<xs:restriction base="xs:string">
			<xs:pattern value="[0-9]*"/>
		</xs:restriction>
	</xs:simpleType>
	<xs:simpleType name="DatoCP_Type">
		<xs:annotation>
			<xs:documentation>Tipo semplice che identifica un elemento di tipo cap</xs:documentation>
		</xs:annotation>
		<xs:restriction base="xs:string">
			<xs:pattern value="[0-9]{5}"/>
		</xs:restriction>
	</xs:simpleType>
</xs:schema>
')
 insert #tA values ('6', 'typesProvincie_v3', '<?xml version="1.0" encoding="UTF-8"?>
<!-- edited with XMLSpy v2012 (http://www.altova.com) by rdobrowolny (Sogei S.p.A.) -->
<xs:schema xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns="urn:www.agenziaentrate.gov.it:specificheTecniche:common" targetNamespace="urn:www.agenziaentrate.gov.it:specificheTecniche:common" elementFormDefault="qualified" attributeFormDefault="unqualified" version="3.0">
	<xs:annotation>
		<xs:documentation xml:lang="it"><![CDATA[
		Versione 3.0 - 10/12/13
		- modificato targetNamespace
		Versione 2.0 - 15/02/12
		- modificato targetNamespace
		]]></xs:documentation>
	</xs:annotation>
	<xs:simpleType name="PR_Type">
		<xs:annotation>
			<xs:documentation>Tipo semplice costituito dalle sigle delle provincie italiane in vigore.</xs:documentation>
		</xs:annotation>
		<xs:union memberTypes="ProvincieItaliane"/>
	</xs:simpleType>
	<xs:simpleType name="PN_Type">
		<xs:annotation>
			<xs:documentation>Tipo semplice costituito dalle sigle delle provincie italiane in vigore,  dalle sigle delle provincie croate di Fiume, Pola e Zara e dalla sigla “EE” che indica un paese estero.</xs:documentation>
		</xs:annotation>
		<xs:union memberTypes="ProvincieItaliane ProvincieCroate Estero"/>
	</xs:simpleType>
	<xs:simpleType name="PE_Type">
		<xs:annotation>
			<xs:documentation>Tipo semplice costituito dalle sigle delle provincie italiane in vigore e dalla sigla “EE” che indica un paese estero.</xs:documentation>
		</xs:annotation>
		<xs:union memberTypes="ProvincieItaliane Estero"/>
	</xs:simpleType>
	<xs:simpleType name="ProvincieItaliane">
		<xs:annotation>
			<xs:documentation>
			Elenco delle provincie italiane in vigore, valori ammessi:
			
				Agrigento				AG
				Alessandria				AL
				Ancona					AN
				Aosta   				AO
				Ascoli Piceno			AP
				L''Aquila				AQ
				Arezzo					AR
				Asti					AT
				Avellino				AV
				Bari					BA
				Bergamo					BG
				Biella					BI
				Belluno					BL
				Benevento				BN
				Bologna					BO
				Brindisi				BR
				Brescia					BS
				Barletta-Andria-Trani	BT
				Bolzano					BZ
				Cagliari				CA
				Campobasso				CB
				Caserta					CE
				Chieti					CH
				Carbonia-Iglessias		CI
				Caltanissetta			CL
				Cuneo					CN
				Como					CO
				Cremona					CR
				Cosenza					CS
				Catania					CT
				Catanzaro				CZ
				Enna					EN
				Forlì-Cesena			FC
				Ferrara					FE
				Foggia					FG
				Firenze					FI
				Fermo					FM
				Frosinone				FR
				Genova					GE
				Gorizia					GO
				Grosseto				GR
				Imperia					IM
				Isernia					IS
				Crotone					KR
				Lecco					LC
				Lecce					LE
				Livorno					LI
				Lodi					LO
				Latina					LT
				Lucca					LU
				Monza e Brianza			MB
				Macerata				MC
				Messina					ME
				Milano					MI
				Mantova					MN
				Modena					MO
				Massa e Carrara			MS
				Matera					MT
				Napoli					NA
				Novara					NO
				Nuoro					NU
				Ogliastra				OG
				Oristano				OR
				Olbia-Tempio			OT
				Palermo					PA
				Piacenza				PC
				Padova					PD
				Pescara					PE
				Perugia					PG
				Pisa					PI
				Pordenone				PN
				Prato					PO
				Parma					PR
				Pistoia					PT
				Pesaro e Urbino			PU
				Pavia					PV
				Potenza					PZ
				Ravenna					RA
				Reggio Calabria			RC
				Reggio Emilia			RE
				Ragusa					RG
				Rieti					RI
				Roma					RM
				Rimini					RN
				Rovigo					RO
				Salerno					SA
				iena					SI
				Sondrio					SO
				La Spezia				SP
				Siracusa				SR
				Sassari					SS
				Savona					SV
				Taranto					TA
				Teramo					TE
				Trento 					TN
				Torino					TO
				Trapani					TP
				Terni					TR
				Trieste					TS
				Treviso					TV
				Udine					UD
				Varese					VA
				Verbano-Cusio-Ossola	VB
				Vercelli				VC
				Venezia					VE
				Vicenza					VI
				Verona					VR
				Medio Campidano			VS
				Viterbo					VT
				Vibo Valentia			VV
			
			</xs:documentation>
		</xs:annotation>
		<xs:restriction base="xs:string">
			<xs:enumeration value="AG"/>
			<xs:enumeration value="AL"/>
			<xs:enumeration value="AN"/>
			<xs:enumeration value="AO"/>
			<xs:enumeration value="AP"/>
			<xs:enumeration value="AQ"/>
			<xs:enumeration value="AR"/>
			<xs:enumeration value="AT"/>
			<xs:enumeration value="AV"/>
			<xs:enumeration value="BA"/>
			<xs:enumeration value="BG"/>
			<xs:enumeration value="BI"/>
			<xs:enumeration value="BL"/>
			<xs:enumeration value="BN"/>
			<xs:enumeration value="BO"/>
			<xs:enumeration value="BR"/>
			<xs:enumeration value="BS"/>
			<xs:enumeration value="BT"/>
			<xs:enumeration value="BZ"/>
			<xs:enumeration value="CA"/>
			<xs:enumeration value="CB"/>
			<xs:enumeration value="CE"/>
			<xs:enumeration value="CH"/>
			<xs:enumeration value="CI"/>
			<xs:enumeration value="CL"/>
			<xs:enumeration value="CN"/>
			<xs:enumeration value="CO"/>
			<xs:enumeration value="CR"/>
			<xs:enumeration value="CS"/>
			<xs:enumeration value="CT"/>
			<xs:enumeration value="CZ"/>
			<xs:enumeration value="EN"/>
			<xs:enumeration value="FC"/>
			<xs:enumeration value="FE"/>
			<xs:enumeration value="FG"/>
			<xs:enumeration value="FI"/>
			<xs:enumeration value="FM"/>
			<xs:enumeration value="FR"/>
			<xs:enumeration value="GE"/>
			<xs:enumeration value="GO"/>
			<xs:enumeration value="GR"/>
			<xs:enumeration value="IM"/>
			<xs:enumeration value="IS"/>
			<xs:enumeration value="KR"/>
			<xs:enumeration value="LC"/>
			<xs:enumeration value="LE"/>
			<xs:enumeration value="LI"/>
			<xs:enumeration value="LO"/>
			<xs:enumeration value="LT"/>
			<xs:enumeration value="LU"/>
			<xs:enumeration value="MB"/>
			<xs:enumeration value="MC"/>
			<xs:enumeration value="ME"/>
			<xs:enumeration value="MI"/>
			<xs:enumeration value="MN"/>
			<xs:enumeration value="MO"/>
			<xs:enumeration value="MS"/>
			<xs:enumeration value="MT"/>
			<xs:enumeration value="NA"/>
			<xs:enumeration value="NO"/>
			<xs:enumeration value="NU"/>
			<xs:enumeration value="OG"/>
			<xs:enumeration value="OR"/>
			<xs:enumeration value="OT"/>
			<xs:enumeration value="PA"/>
			<xs:enumeration value="PC"/>
			<xs:enumeration value="PD"/>
			<xs:enumeration value="PE"/>
			<xs:enumeration value="PG"/>
			<xs:enumeration value="PI"/>
			<xs:enumeration value="PN"/>
			<xs:enumeration value="PO"/>
			<xs:enumeration value="PR"/>
			<xs:enumeration value="PT"/>
			<xs:enumeration value="PU"/>
			<xs:enumeration value="PV"/>
			<xs:enumeration value="PZ"/>
			<xs:enumeration value="RA"/>
			<xs:enumeration value="RC"/>
			<xs:enumeration value="RE"/>
			<xs:enumeration value="RG"/>
			<xs:enumeration value="RI"/>
			<xs:enumeration value="RM"/>
			<xs:enumeration value="RN"/>
			<xs:enumeration value="RO"/>
			<xs:enumeration value="SA"/>
			<xs:enumeration value="SI"/>
			<xs:enumeration value="SO"/>
			<xs:enumeration value="SP"/>
			<xs:enumeration value="SR"/>
			<xs:enumeration value="SS"/>
			<xs:enumeration value="SV"/>
			<xs:enumeration value="TA"/>
			<xs:enumeration value="TE"/>
			<xs:enumeration value="TN"/>
			<xs:enumeration value="TO"/>
			<xs:enumeration value="TP"/>
			<xs:enumeration value="TR"/>
			<xs:enumeration value="TS"/>
			<xs:enumeration value="TV"/>
			<xs:enumeration value="UD"/>
			<xs:enumeration value="VA"/>
			<xs:enumeration value="VB"/>
			<xs:enumeration value="VC"/>
			<xs:enumeration value="VE"/>
			<xs:enumeration value="VI"/>
			<xs:enumeration value="VR"/>
			<xs:enumeration value="VS"/>
			<xs:enumeration value="VT"/>
			<xs:enumeration value="VV"/>
		</xs:restriction>
	</xs:simpleType>
	<xs:simpleType name="ProvincieCroate">
		<xs:restriction base="xs:string">
			<xs:enumeration value="FU">
				<xs:annotation>
					<xs:documentation>Fiume</xs:documentation>
				</xs:annotation>
			</xs:enumeration>
			<xs:enumeration value="PL">
				<xs:annotation>
					<xs:documentation>Pola</xs:documentation>
				</xs:annotation>
			</xs:enumeration>
			<xs:enumeration value="ZA">
				<xs:annotation>
					<xs:documentation>Zara</xs:documentation>
				</xs:annotation>
			</xs:enumeration>
		</xs:restriction>
	</xs:simpleType>
	<xs:simpleType name="Estero">
		<xs:restriction base="xs:string">
			<xs:enumeration value="EE"/>
		</xs:restriction>
	</xs:simpleType>
</xs:schema>
')
 insert #tA values ('7', 'xmldsig-core-schema', '<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE schema
  PUBLIC "-//W3C//DTD XMLSchema 200102//EN" "http://www.w3.org/2001/XMLSchema.dtd"
 [
   <!ATTLIST schema 
     xmlns:ds CDATA #FIXED "http://www.w3.org/2000/09/xmldsig#">
   <!ENTITY dsig ''http://www.w3.org/2000/09/xmldsig#''>
   <!ENTITY % p ''''>
   <!ENTITY % s ''''>
  ]>

<!-- Schema for XML Signatures
    http://www.w3.org/2000/09/xmldsig#
    $Revision: 1.1 $ on $Date: 2002/02/08 20:32:26 $ by $Author: reagle $

    Copyright 2001 The Internet Society and W3C (Massachusetts Institute
    of Technology, Institut National de Recherche en Informatique et en
    Automatique, Keio University). All Rights Reserved.
    http://www.w3.org/Consortium/Legal/

    This document is governed by the W3C Software License [1] as described
    in the FAQ [2].

    [1] http://www.w3.org/Consortium/Legal/copyright-software-19980720
    [2] http://www.w3.org/Consortium/Legal/IPR-FAQ-20000620.html#DTD
-->


<schema xmlns="http://www.w3.org/2001/XMLSchema"
        xmlns:ds="http://www.w3.org/2000/09/xmldsig#"
        targetNamespace="http://www.w3.org/2000/09/xmldsig#"
        version="0.1" elementFormDefault="qualified"> 

<!-- Basic Types Defined for Signatures -->

<simpleType name="CryptoBinary">
  <restriction base="base64Binary">
  </restriction>
</simpleType>

<!-- Start Signature -->

<element name="Signature" type="ds:SignatureType"/>
<complexType name="SignatureType">
  <sequence> 
    <element ref="ds:SignedInfo"/> 
    <element ref="ds:SignatureValue"/> 
    <element ref="ds:KeyInfo" minOccurs="0"/> 
    <element ref="ds:Object" minOccurs="0" maxOccurs="unbounded"/> 
  </sequence>  
  <attribute name="Id" type="ID" use="optional"/>
</complexType>

  <element name="SignatureValue" type="ds:SignatureValueType"/> 
  <complexType name="SignatureValueType">
    <simpleContent>
      <extension base="base64Binary">
        <attribute name="Id" type="ID" use="optional"/>
      </extension>
    </simpleContent>
  </complexType>

<!-- Start SignedInfo -->

<element name="SignedInfo" type="ds:SignedInfoType"/>
<complexType name="SignedInfoType">
  <sequence> 
    <element ref="ds:CanonicalizationMethod"/> 
    <element ref="ds:SignatureMethod"/> 
    <element ref="ds:Reference" maxOccurs="unbounded"/> 
  </sequence>  
  <attribute name="Id" type="ID" use="optional"/> 
</complexType>

  <element name="CanonicalizationMethod" type="ds:CanonicalizationMethodType"/> 
  <complexType name="CanonicalizationMethodType" mixed="true">
    <sequence>
      <any namespace="##any" minOccurs="0" maxOccurs="unbounded"/>
      <!-- (0,unbounded) elements from (1,1) namespace -->
    </sequence>
    <attribute name="Algorithm" type="anyURI" use="required"/> 
  </complexType>

  <element name="SignatureMethod" type="ds:SignatureMethodType"/>
  <complexType name="SignatureMethodType" mixed="true">
    <sequence>
      <element name="HMACOutputLength" minOccurs="0" type="ds:HMACOutputLengthType"/>
      <any namespace="##other" minOccurs="0" maxOccurs="unbounded"/>
      <!-- (0,unbounded) elements from (1,1) external namespace -->
    </sequence>
    <attribute name="Algorithm" type="anyURI" use="required"/> 
  </complexType>

<!-- Start Reference -->

<element name="Reference" type="ds:ReferenceType"/>
<complexType name="ReferenceType">
  <sequence> 
    <element ref="ds:Transforms" minOccurs="0"/> 
    <element ref="ds:DigestMethod"/> 
    <element ref="ds:DigestValue"/> 
  </sequence>
  <attribute name="Id" type="ID" use="optional"/> 
  <attribute name="URI" type="anyURI" use="optional"/> 
  <attribute name="Type" type="anyURI" use="optional"/> 
</complexType>

  <element name="Transforms" type="ds:TransformsType"/>
  <complexType name="TransformsType">
    <sequence>
      <element ref="ds:Transform" maxOccurs="unbounded"/>  
    </sequence>
  </complexType>

  <element name="Transform" type="ds:TransformType"/>
  <complexType name="TransformType" mixed="true">
    <choice minOccurs="0" maxOccurs="unbounded"> 
      <any namespace="##other" processContents="lax"/>
      <!-- (1,1) elements from (0,unbounded) namespaces -->
      <element name="XPath" type="string"/> 
    </choice>
    <attribute name="Algorithm" type="anyURI" use="required"/> 
  </complexType>

<!-- End Reference -->

<element name="DigestMethod" type="ds:DigestMethodType"/>
<complexType name="DigestMethodType" mixed="true"> 
  <sequence>
    <any namespace="##other" processContents="lax" minOccurs="0" maxOccurs="unbounded"/>
  </sequence>    
  <attribute name="Algorithm" type="anyURI" use="required"/> 
</complexType>

<element name="DigestValue" type="ds:DigestValueType"/>
<simpleType name="DigestValueType">
  <restriction base="base64Binary"/>
</simpleType>

<!-- End SignedInfo -->

<!-- Start KeyInfo -->

<element name="KeyInfo" type="ds:KeyInfoType"/> 
<complexType name="KeyInfoType" mixed="true">
  <choice maxOccurs="unbounded">     
    <element ref="ds:KeyName"/> 
    <element ref="ds:KeyValue"/> 
    <element ref="ds:RetrievalMethod"/> 
    <element ref="ds:X509Data"/> 
    <element ref="ds:PGPData"/> 
    <element ref="ds:SPKIData"/>
    <element ref="ds:MgmtData"/>
    <any processContents="lax" namespace="##other"/>
    <!-- (1,1) elements from (0,unbounded) namespaces -->
  </choice>
  <attribute name="Id" type="ID" use="optional"/> 
</complexType>

  <element name="KeyName" type="string"/>
  <element name="MgmtData" type="string"/>

  <element name="KeyValue" type="ds:KeyValueType"/> 
  <complexType name="KeyValueType" mixed="true">
   <choice>
     <element ref="ds:DSAKeyValue"/>
     <element ref="ds:RSAKeyValue"/>
     <any namespace="##other" processContents="lax"/>
   </choice>
  </complexType>

  <element name="RetrievalMethod" type="ds:RetrievalMethodType"/> 
  <complexType name="RetrievalMethodType">
    <sequence>
      <element ref="ds:Transforms" minOccurs="0"/> 
    </sequence>  
    <attribute name="URI" type="anyURI"/>
    <attribute name="Type" type="anyURI" use="optional"/>
  </complexType>

<!-- Start X509Data -->

<element name="X509Data" type="ds:X509DataType"/> 
<complexType name="X509DataType">
  <sequence maxOccurs="unbounded">
    <choice>
      <element name="X509IssuerSerial" type="ds:X509IssuerSerialType"/>
      <element name="X509SKI" type="base64Binary"/>
      <element name="X509SubjectName" type="string"/>
      <element name="X509Certificate" type="base64Binary"/>
      <element name="X509CRL" type="base64Binary"/>
      <any namespace="##other" processContents="lax"/>
    </choice>
  </sequence>
</complexType>

<complexType name="X509IssuerSerialType"> 
  <sequence> 
    <element name="X509IssuerName" type="string"/> 
    <element name="X509SerialNumber" type="integer"/> 
  </sequence>
</complexType>

<!-- End X509Data -->

<!-- Begin PGPData -->

<element name="PGPData" type="ds:PGPDataType"/> 
<complexType name="PGPDataType"> 
  <choice>
    <sequence>
      <element name="PGPKeyID" type="base64Binary"/> 
      <element name="PGPKeyPacket" type="base64Binary" minOccurs="0"/> 
      <any namespace="##other" processContents="lax" minOccurs="0"
       maxOccurs="unbounded"/>
    </sequence>
    <sequence>
      <element name="PGPKeyPacket" type="base64Binary"/> 
      <any namespace="##other" processContents="lax" minOccurs="0"
       maxOccurs="unbounded"/>
    </sequence>
  </choice>
</complexType>

<!-- End PGPData -->

<!-- Begin SPKIData -->

<element name="SPKIData" type="ds:SPKIDataType"/> 
<complexType name="SPKIDataType">
  <sequence maxOccurs="unbounded">
    <element name="SPKISexp" type="base64Binary"/>
    <any namespace="##other" processContents="lax" minOccurs="0"/>
  </sequence>
</complexType> 

<!-- End SPKIData -->

<!-- End KeyInfo -->

<!-- Start Object (Manifest, SignatureProperty) -->

<element name="Object" type="ds:ObjectType"/> 
<complexType name="ObjectType" mixed="true">
  <sequence minOccurs="0" maxOccurs="unbounded">
    <any namespace="##any" processContents="lax"/>
  </sequence>
  <attribute name="Id" type="ID" use="optional"/> 
  <attribute name="MimeType" type="string" use="optional"/> <!-- add a grep facet -->
  <attribute name="Encoding" type="anyURI" use="optional"/> 
</complexType>

<element name="Manifest" type="ds:ManifestType"/> 
<complexType name="ManifestType">
  <sequence>
    <element ref="ds:Reference" maxOccurs="unbounded"/> 
  </sequence>
  <attribute name="Id" type="ID" use="optional"/> 
</complexType>

<element name="SignatureProperties" type="ds:SignaturePropertiesType"/> 
<complexType name="SignaturePropertiesType">
  <sequence>
    <element ref="ds:SignatureProperty" maxOccurs="unbounded"/> 
  </sequence>
  <attribute name="Id" type="ID" use="optional"/> 
</complexType>

   <element name="SignatureProperty" type="ds:SignaturePropertyType"/> 
   <complexType name="SignaturePropertyType" mixed="true">
     <choice maxOccurs="unbounded">
       <any namespace="##other" processContents="lax"/>
       <!-- (1,1) elements from (1,unbounded) namespaces -->
     </choice>
     <attribute name="Target" type="anyURI" use="required"/> 
     <attribute name="Id" type="ID" use="optional"/> 
   </complexType>

<!-- End Object (Manifest, SignatureProperty) -->

<!-- Start Algorithm Parameters -->

<simpleType name="HMACOutputLengthType">
  <restriction base="integer"/>
</simpleType>

<!-- Start KeyValue Element-types -->

<element name="DSAKeyValue" type="ds:DSAKeyValueType"/>
<complexType name="DSAKeyValueType">
  <sequence>
    <sequence minOccurs="0">
      <element name="P" type="ds:CryptoBinary"/>
      <element name="Q" type="ds:CryptoBinary"/>
    </sequence>
    <element name="G" type="ds:CryptoBinary" minOccurs="0"/>
    <element name="Y" type="ds:CryptoBinary"/>
    <element name="J" type="ds:CryptoBinary" minOccurs="0"/>
    <sequence minOccurs="0">
      <element name="Seed" type="ds:CryptoBinary"/>
      <element name="PgenCounter" type="ds:CryptoBinary"/>
    </sequence>
  </sequence>
</complexType>

<element name="RSAKeyValue" type="ds:RSAKeyValueType"/>
<complexType name="RSAKeyValueType">
  <sequence>
    <element name="Modulus" type="ds:CryptoBinary"/> 
    <element name="Exponent" type="ds:CryptoBinary"/> 
  </sequence>
</complexType> 

<!-- End KeyValue Element-types -->

<!-- End Signature -->

</schema>
')
 insert #tA values ('8', 'DatiFatturav2.0', '<?xml version="1.0" encoding="utf-8"?>
<xs:schema xmlns:xs="http://www.w3.org/2001/XMLSchema" 
	xmlns:ds="http://www.w3.org/2000/09/xmldsig#" 
	xmlns="http://ivaservizi.agenziaentrate.gov.it/docs/xsd/fatture/v2.0" 
	targetNamespace="http://ivaservizi.agenziaentrate.gov.it/docs/xsd/fatture/v2.0" version="1.0">

  <xs:import namespace="http://www.w3.org/2000/09/xmldsig#" schemaLocation="xmldsig-core-schema.xsd" />
    
  <!-- =================================================================== -->
  <!-- ELEMENTI                                                            -->
  <!-- =================================================================== -->
  <xs:element name="DatiFattura" type="DatiFatturaType">
    <xs:annotation>
      <xs:documentation>XML schema fatture emesse e ricevute ex D.Lgs. 127/205 (art.1, c.3) 2.0</xs:documentation>
    </xs:annotation>
  </xs:element>  
  
  <!-- =================================================================== -->
  <!-- TIPI                                                                -->
  <!-- =================================================================== -->
  <xs:complexType name="DatiFatturaType">
    <xs:sequence>
      <xs:element name="DatiFatturaHeader"    type="DatiFatturaHeaderType"      minOccurs="0" />
	  <xs:choice>
	    <xs:element name="DTE" type="DTEType" />
	    <xs:element name="DTR" type="DTRType" />
	    <xs:element name="ANN" type="ANNType" />
      </xs:choice>
      <xs:element ref ="ds:Signature" minOccurs="0" />    
    </xs:sequence>
    <xs:attribute name="versione" type="VersioneType" use="required" />
  </xs:complexType>  
  
  <xs:complexType name="DatiFatturaHeaderType">
    <xs:sequence>
      <xs:element name="ProgressivoInvio" type="String10Type"      minOccurs="0" />
      <xs:element name="Dichiarante"      type="DichiaranteType"   minOccurs="0" />
      <xs:element name="IdSistema"        type="CodiceFiscaleType" minOccurs="0" />
    </xs:sequence>
  </xs:complexType>     
  
  <xs:complexType name="DichiaranteType">
    <xs:sequence>
      <xs:element name="CodiceFiscale"             type="CodiceFiscaleType" />
      <xs:element name="Carica"                    type="CaricaType"        />
    </xs:sequence>
  </xs:complexType>  
  
  <xs:complexType name="DTEType">
    <xs:sequence>
      <xs:element name="CedentePrestatoreDTE"      type="CedentePrestatoreDTEType"                      />
      <xs:element name="CessionarioCommittenteDTE" type="CessionarioCommittenteDTEType" maxOccurs="1000"/>
      <xs:element name="Rettifica"                 type="RettificaType"                 minOccurs="0"  />
    </xs:sequence>
  </xs:complexType>
  
  <xs:complexType name="DTRType">
    <xs:sequence>
      <xs:element name="CessionarioCommittenteDTR" type="CessionarioCommittenteDTRType"                  />
      <xs:element name="CedentePrestatoreDTR"      type="CedentePrestatoreDTRType"      maxOccurs="1000" />
      <xs:element name="Rettifica"                 type="RettificaType"                 minOccurs="0"    />
    </xs:sequence>
  </xs:complexType>
  
  <xs:complexType name="ANNType">
    <xs:sequence>
      <xs:element name="IdFile"                    type="String18Type" />
      <xs:element name="Posizione"                 type="PosizioneType"                 minOccurs="0" />
    </xs:sequence>
  </xs:complexType>  
  
  <xs:complexType name="CedentePrestatoreDTEType">
    <xs:annotation><xs:documentation>Blocco relativo ai dati del Cedente / Prestatore</xs:documentation></xs:annotation>
    <xs:sequence>
      <xs:element name="IdentificativiFiscali"   type="IdentificativiFiscaliITType"       />
      <xs:element name="AltriDatiIdentificativi" type="AltriDatiIdentificativiNoSedeType" />
    </xs:sequence>   
  </xs:complexType>  
  
  <xs:complexType name="CedentePrestatoreDTRType">
    <xs:annotation><xs:documentation>Blocco relativo ai dati del Cedente / Prestatore</xs:documentation></xs:annotation>
    <xs:sequence>
      <xs:element name="IdentificativiFiscali"   type="IdentificativiFiscaliType"                         />
      <xs:element name="AltriDatiIdentificativi" type="AltriDatiIdentificativiNoCAPType"                  />
      <xs:element name="DatiFatturaBodyDTR"      type="DatiFatturaBodyDTRType"           maxOccurs="1000" />
    </xs:sequence>   
  </xs:complexType>  
  
  <xs:complexType name="CessionarioCommittenteDTEType">
    <xs:annotation><xs:documentation>Blocco relativo ai dati del Cessionario / Committente</xs:documentation></xs:annotation>
    <xs:sequence>
      <xs:element name="IdentificativiFiscali"   type="IdentificativiFiscaliNoIVAType"   minOccurs="0"    />
      <xs:element name="AltriDatiIdentificativi" type="AltriDatiIdentificativiNoCAPType" minOccurs="0"    />
      <xs:element name="DatiFatturaBodyDTE"      type="DatiFatturaBodyDTEType"           maxOccurs="1000" />
    </xs:sequence>
  </xs:complexType>
    
  <xs:complexType name="CessionarioCommittenteDTRType">
    <xs:annotation><xs:documentation>Blocco relativo ai dati del Cessionario / Committente</xs:documentation></xs:annotation>
    <xs:sequence>
      <xs:element name="IdentificativiFiscali"   type="IdentificativiFiscaliITType" />
      <xs:element name="AltriDatiIdentificativi" type="AltriDatiIdentificativiNoSedeType" minOccurs="0" />
    </xs:sequence>
  </xs:complexType>
    
  <xs:complexType name="DatiFatturaBodyDTEType">
    <xs:sequence>
      <xs:element name="DatiGenerali"  type="DatiGeneraliType"                   />
      <xs:element name="DatiRiepilogo" type="DatiRiepilogoType" maxOccurs="1000" />
    </xs:sequence>
  </xs:complexType> 
  
  <xs:complexType name="DatiFatturaBodyDTRType">
    <xs:sequence>
      <xs:element name="DatiGenerali"  type="DatiGeneraliDTRType"                  />
      <xs:element name="DatiRiepilogo" type="DatiRiepilogoType"   maxOccurs="1000" />
    </xs:sequence>
  </xs:complexType> 
    
  <xs:complexType name="RettificaType">
    <xs:sequence>
      <xs:element name="IdFile"                    type="String18Type"  />
      <xs:element name="Posizione"                 type="PosizioneType" />
    </xs:sequence>
  </xs:complexType>
  
  <xs:complexType name="IdentificativiFiscaliType">
    <xs:sequence>
      <xs:element name="IdFiscaleIVA"  type="IdFiscaleType"                   />
      <xs:element name="CodiceFiscale" type="CodiceFiscaleType" minOccurs="0" />
    </xs:sequence>
  </xs:complexType>  
  
  <xs:complexType name="IdentificativiFiscaliITType">
    <xs:sequence>
      <xs:element name="IdFiscaleIVA"  type="IdFiscaleITType"                 />
      <xs:element name="CodiceFiscale" type="CodiceFiscaleType" minOccurs="0" />
    </xs:sequence>
  </xs:complexType>  
  
  <xs:complexType name="IdentificativiFiscaliNoIVAType">
    <xs:sequence>
      <xs:element name="IdFiscaleIVA"  type="IdFiscaleType"     minOccurs="0" />
      <xs:element name="CodiceFiscale" type="CodiceFiscaleType" minOccurs="0" />
    </xs:sequence>
  </xs:complexType>      
 
  <xs:complexType name="AltriDatiIdentificativiNoSedeType">
    <xs:sequence>
      <xs:choice>
        <xs:sequence>
          <xs:element name="Denominazione" type="String80LatinType"/>
        </xs:sequence>
        <xs:sequence>
          <xs:element name="Nome"          type="String60LatinType"/>
          <xs:element name="Cognome"       type="String60LatinType"/>
        </xs:sequence>
      </xs:choice>
      <xs:element name="Sede"                  type="IndirizzoType"               minOccurs="0" />
	  <xs:element name="StabileOrganizzazione" type="IndirizzoType"               minOccurs="0" />
	  <xs:element name="RappresentanteFiscale" type="RappresentanteFiscaleITType" minOccurs="0" />
    </xs:sequence>
  </xs:complexType>       
 
  <xs:complexType name="AltriDatiIdentificativiNoCAPType">
    <xs:sequence>
      <xs:choice>
        <xs:sequence>
          <xs:element name="Denominazione" type="String80LatinType"/>
        </xs:sequence>
        <xs:sequence>
          <xs:element name="Nome"          type="String60LatinType" />
          <xs:element name="Cognome"       type="String60LatinType" />
        </xs:sequence>
      </xs:choice>
      <xs:element name="Sede"                  type="IndirizzoNoCAPType"                      />
	  <xs:element name="StabileOrganizzazione" type="IndirizzoType"             minOccurs="0" />
	  <xs:element name="RappresentanteFiscale" type="RappresentanteFiscaleType" minOccurs="0" />
    </xs:sequence>
  </xs:complexType> 
  
  <xs:complexType name="IndirizzoNoCAPType">
    <xs:sequence>
      <xs:element name="Indirizzo"    type="String60LatinType"                 />
      <xs:element name="NumeroCivico" type="NumeroCivicoType"    minOccurs="0" />
      <xs:element name="CAP"          type="CAPType"             minOccurs="0" />
      <xs:element name="Comune"       type="String60LatinType"                 />
      <xs:element name="Provincia"    type="ProvinciaType"       minOccurs="0" />
      <xs:element name="Nazione"      type="NazioneType"                       />
    </xs:sequence>
  </xs:complexType> 
    
  <xs:complexType name="IndirizzoType">
    <xs:sequence>
      <xs:element name="Indirizzo"    type="String60LatinType"                 />
      <xs:element name="NumeroCivico" type="NumeroCivicoType"    minOccurs="0" />
      <xs:element name="CAP"          type="CAPType"                           />
      <xs:element name="Comune"       type="String60LatinType"                 />
      <xs:element name="Provincia"    type="ProvinciaType"       minOccurs="0" />
      <xs:element name="Nazione"      type="NazioneType"                       />
    </xs:sequence>
  </xs:complexType> 
  
  <xs:complexType name="RappresentanteFiscaleType">
    <xs:sequence>
      <xs:element name="IdFiscaleIVA"  type="IdFiscaleType" /> 
      <xs:choice>
        <xs:sequence>
          <xs:element name="Denominazione" type="String80LatinType"/>
        </xs:sequence>
        <xs:sequence>
          <xs:element name="Nome"          type="String60LatinType"/>
          <xs:element name="Cognome"       type="String60LatinType"/>
        </xs:sequence>
      </xs:choice>  
    </xs:sequence>
  </xs:complexType>  
  
  <xs:complexType name="RappresentanteFiscaleITType">
    <xs:sequence>
      <xs:element name="IdFiscaleIVA"  type="IdFiscaleITIvaType" /> 
      <xs:choice>
        <xs:sequence>
          <xs:element name="Denominazione" type="String80LatinType"/>
        </xs:sequence>
        <xs:sequence>
          <xs:element name="Nome"          type="String60LatinType"/>
          <xs:element name="Cognome"       type="String60LatinType"/>
        </xs:sequence>
      </xs:choice>    
    </xs:sequence>
  </xs:complexType>  
  
  <xs:complexType name="DatiGeneraliType">
    <xs:sequence>
      <xs:element name="TipoDocumento" type="TipoDocumentoType" />
      <xs:element name="Data"          type="DataFatturaType"   />
      <xs:element name="Numero"        type="String20Type"      />
    </xs:sequence>
  </xs:complexType>    
  
  <xs:complexType name="DatiGeneraliDTRType">
    <xs:sequence>
      <xs:element name="TipoDocumento"     type="TipoDocumentoType" />
      <xs:element name="Data"              type="DataFatturaType"   />
      <xs:element name="Numero"            type="String20Type"      />
      <xs:element name="DataRegistrazione" type="DataFatturaType"   />
    </xs:sequence>
  </xs:complexType>    
  
  <xs:complexType name="DatiRiepilogoType">
    <xs:sequence>
      <xs:element name="ImponibileImporto" type="Amount2DecimalType" />
      <xs:element name="DatiIVA"           type="DatiIVAType" />
      <xs:element name="Natura"            type="NaturaType"             minOccurs="0" />
      <xs:element name="Detraibile"        type="RateType"               minOccurs="0" />
      <xs:element name="Deducibile"        type="DeducibileType"         minOccurs="0" />
      <xs:element name="EsigibilitaIVA"    type="EsigibilitaIVAType"     minOccurs="0" />
    </xs:sequence>
  </xs:complexType>  
  
  <xs:complexType name="DatiIVAType">
    <xs:sequence>
      <xs:element name="Imposta"  type="Amount2DecimalType" minOccurs="0"/>
      <xs:element name="Aliquota" type="RateType"           minOccurs="0" />
    </xs:sequence>
  </xs:complexType> 
    
  <xs:complexType name="IdFiscaleType">
	<xs:sequence>
	  <xs:element name="IdPaese"  type="NazioneType" />
	  <xs:element name="IdCodice" type="CodiceType"  />
	</xs:sequence>
  </xs:complexType>
    
  <xs:complexType name="IdFiscaleITType">
	<xs:sequence>
	  <xs:element name="IdPaese"  type="NazioneITType" />
	  <xs:element name="IdCodice" type="CodiceType"    />
	</xs:sequence>
  </xs:complexType>
    
  <xs:complexType name="IdFiscaleITIvaType">
	<xs:sequence>
	  <xs:element name="IdPaese"  type="NazioneITType" />
	  <xs:element name="IdCodice" type="CodiceIvaType"    />
	</xs:sequence>
  </xs:complexType>
  
  <xs:simpleType name="CodiceFiscaleType">
    <xs:restriction base="xs:string">
      <xs:pattern value="[A-Z0-9]{11,16}" />
    </xs:restriction>
  </xs:simpleType>
  
  <xs:simpleType name="NazioneType">
    <xs:restriction base="xs:string">
      <xs:pattern value="[A-Z]{2}" />
    </xs:restriction>
  </xs:simpleType>
  
  <xs:simpleType name="NazioneITType">
    <xs:restriction base="xs:string">
      <xs:length value="2" />
      <xs:enumeration value="IT">
        <xs:annotation><xs:documentation>Italia</xs:documentation></xs:annotation>
      </xs:enumeration>
    </xs:restriction>
  </xs:simpleType>

  <xs:simpleType name="CodiceType">
    <xs:restriction base="xs:string">
      <xs:minLength value="1" />
      <xs:maxLength value="28" />
    </xs:restriction>
  </xs:simpleType>

  <xs:simpleType name="CodiceIvaType">
    <xs:restriction base="xs:string">
      <xs:minLength value="1" />
      <xs:maxLength value="11" />
    </xs:restriction>
  </xs:simpleType>  
  
  <xs:simpleType name="NumeroCivicoType">
    <xs:restriction base="xs:normalizedString">
      <xs:pattern value="(\p{IsBasicLatin}{1,8})" />
    </xs:restriction>
  </xs:simpleType>

  <xs:simpleType name="CAPType">
    <xs:restriction base="xs:string">
      <xs:pattern value="[0-9][0-9][0-9][0-9][0-9]" />
    </xs:restriction>
  </xs:simpleType>

  <xs:simpleType name="ProvinciaType">
    <xs:restriction base="xs:string">
      <xs:pattern value="[A-Z]{2}" />
    </xs:restriction>
  </xs:simpleType>
  
  <xs:simpleType name="TipoDocumentoType">
    <xs:restriction base="xs:string">
      <xs:length value="4" />
      <xs:enumeration value="TD01">
        <xs:annotation><xs:documentation>Fattura</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="TD04">
        <xs:annotation><xs:documentation>Nota di credito</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="TD05">
        <xs:annotation><xs:documentation>Nota di debito</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="TD07">
        <xs:annotation><xs:documentation>Fattura semplificata</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="TD08">
        <xs:annotation><xs:documentation>Nota di credito semplificata</xs:documentation></xs:annotation>
      </xs:enumeration>
	  <xs:enumeration value="TD10">
        <xs:annotation><xs:documentation>Acquisto beni intra</xs:documentation></xs:annotation>
      </xs:enumeration>
	  <xs:enumeration value="TD11">
        <xs:annotation><xs:documentation>Acquisto servizi intra</xs:documentation></xs:annotation>
      </xs:enumeration>
    </xs:restriction>
  </xs:simpleType>
  
  <xs:simpleType name="DataFatturaType">
    <xs:restriction base="xs:date">
      <xs:minInclusive value="1970-01-01" />
    </xs:restriction>
  </xs:simpleType>
  
  <xs:simpleType name="PosizioneType">
    <xs:restriction base="xs:integer">
      <xs:minInclusive value="1" />
      <xs:maxInclusive value="9999999" />
    </xs:restriction>
  </xs:simpleType>  
  
  <xs:simpleType name="CaricaType">
    <xs:restriction base="xs:integer">
      <xs:minInclusive value="1" />
      <xs:maxInclusive value="15" />
    </xs:restriction>
  </xs:simpleType>  
  
  <!-- STRINGHE -->
  <xs:simpleType name="String10Type">
    <xs:restriction base="xs:normalizedString">
      <xs:pattern value="(\p{IsBasicLatin}{1,10})" />
    </xs:restriction>
  </xs:simpleType>
  
  <xs:simpleType name="String18Type">
    <xs:restriction base="xs:normalizedString">
      <xs:pattern value="(\p{IsBasicLatin}{1,18})" />
    </xs:restriction>
  </xs:simpleType>
  
  <xs:simpleType name="String20Type">
    <xs:restriction base="xs:normalizedString">
      <xs:pattern value="(\p{IsBasicLatin}{1,20})" />
    </xs:restriction>
  </xs:simpleType>
    
  <xs:simpleType name="String60LatinType">
    <xs:restriction base="xs:normalizedString">
      <xs:pattern value="[\p{IsBasicLatin}\p{IsLatin-1Supplement}]{1,60}" />
    </xs:restriction>
  </xs:simpleType>

  <xs:simpleType name="String80LatinType">
    <xs:restriction base="xs:normalizedString">
      <xs:pattern value="[\p{IsBasicLatin}\p{IsLatin-1Supplement}]{1,80}" />
    </xs:restriction>
  </xs:simpleType>
  
  <xs:simpleType name="VersioneType">
    <xs:restriction base="xs:string">
      <xs:length value="5" />      
	  <xs:enumeration value="DAT20">
	    <xs:annotation><xs:documentation>Dati fatture versione 2.0</xs:documentation></xs:annotation>
	  </xs:enumeration>
    </xs:restriction>
  </xs:simpleType>
  
  <xs:simpleType name="NaturaType">
    <xs:restriction base="xs:string">
      <xs:enumeration value="N1">
        <xs:annotation><xs:documentation>Escluse ex. art. 15</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="N2">
        <xs:annotation><xs:documentation>Non soggette</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="N3">
        <xs:annotation><xs:documentation>Non Imponibili</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="N4">
        <xs:annotation><xs:documentation>Esenti</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="N5">
        <xs:annotation><xs:documentation>Regime del margine</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="N6">
        <xs:annotation><xs:documentation>Inversione contabile (reverse charge)</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="N7">
        <xs:annotation>
                       <xs:documentation> IVA assolta in altro stato UE
	                                      (vendite a distanza ex art. 40 c. 3 e 4 e art. 41 c. 1 lett. b,  DL 331/93; 
	                                       prestazione di servizi di telecomunicazioni, tele-radiodiffusione ed elettronici 
	                                       ex art. 7-sexies lett. f, g, art. 74-sexies DPR 633/72)
                       </xs:documentation></xs:annotation>
      </xs:enumeration>
    </xs:restriction>
  </xs:simpleType>

  <xs:simpleType name="DeducibileType">
    <xs:restriction base="xs:string">
      <xs:length value="2" />
      <xs:enumeration value="SI">
        <xs:annotation><xs:documentation>Spesa deducibile</xs:documentation></xs:annotation>
      </xs:enumeration>
    </xs:restriction>
  </xs:simpleType>
  
  
  <xs:simpleType name="EsigibilitaIVAType">
    <xs:restriction base="xs:string">
      <xs:minLength value="1" />
      <xs:maxLength value="1" />
      <xs:enumeration value="D">
        <xs:annotation>
          <xs:documentation>esigibilità differita</xs:documentation>
        </xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="I">
        <xs:annotation>
          <xs:documentation>esigibilità immediata</xs:documentation>
        </xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="S">
        <xs:annotation>
          <xs:documentation>scissione dei pagamenti</xs:documentation>
        </xs:annotation>
      </xs:enumeration>
    </xs:restriction>
  </xs:simpleType>
  
   <xs:simpleType name="RateType">
    <xs:restriction base="xs:decimal">
      <xs:maxInclusive value="100.00" />
      <xs:pattern value="[0-9]{1,3}\.[0-9]{2}" />
    </xs:restriction>
  </xs:simpleType>  
  
  <!-- NUMERI -->
  <xs:simpleType name="Amount2DecimalType">
    <xs:restriction base="xs:decimal">
      <xs:pattern value="[\-]?[0-9]{1,11}\.[0-9]{2}" />
    </xs:restriction>
  </xs:simpleType>
  
</xs:schema>')
 insert #tA values ('9', 'DatiFatturav2.1', '<?xml version="1.0" encoding="utf-8"?>
<xs:schema xmlns:xs="http://www.w3.org/2001/XMLSchema" 
	xmlns:ds="http://www.w3.org/2000/09/xmldsig#" 
	xmlns="http://ivaservizi.agenziaentrate.gov.it/docs/xsd/fatture/v2.0" 
	targetNamespace="http://ivaservizi.agenziaentrate.gov.it/docs/xsd/fatture/v2.0" 
	version="2.1">

  <xs:import namespace="http://www.w3.org/2000/09/xmldsig#" schemaLocation="http://www.w3.org/TR/2002/REC-xmldsig-core-20020212/xmldsig-core-schema.xsd" />
    
  <!-- =================================================================== -->
  <!-- ELEMENTI                                                            -->
  <!-- =================================================================== -->
  <xs:element name="DatiFattura" type="DatiFatturaType">
    <xs:annotation>
      <xs:documentation>XML schema fatture emesse e ricevute ex D.Lgs. 127/205 (art.1, c.3) 2.1</xs:documentation>
    </xs:annotation>
  </xs:element>  
  
  <!-- =================================================================== -->
  <!-- TIPI                                                                -->
  <!-- =================================================================== -->
  <xs:complexType name="DatiFatturaType">
    <xs:sequence>
      <xs:element name="DatiFatturaHeader"    type="DatiFatturaHeaderType"      minOccurs="0" />
	  <xs:choice>
	    <xs:element name="DTE" type="DTEType" />
	    <xs:element name="DTR" type="DTRType" />
	    <xs:element name="ANN" type="ANNType" />
      </xs:choice>
      <xs:element ref ="ds:Signature" minOccurs="0" />
    </xs:sequence>
    <xs:attribute name="versione" type="VersioneType" use="required" />
  </xs:complexType>  
  
  <xs:complexType name="DatiFatturaHeaderType">
    <xs:sequence>
      <xs:element name="ProgressivoInvio" type="String10Type"                minOccurs="0" />
      <xs:element name="Dichiarante"      type="DichiaranteType"             minOccurs="0" />
      <xs:element name="IdSistema"        type="CodiceFiscaleType"           minOccurs="0" />
      <xs:element name="SpazioDatiFattura" type="xs:normalizedString" minOccurs="0" />
    </xs:sequence>
  </xs:complexType>     
  
  <xs:complexType name="DichiaranteType">
    <xs:sequence>
      <xs:element name="CodiceFiscale"             type="CodiceFiscaleType" />
      <xs:element name="Carica"                    type="CaricaType"        />
    </xs:sequence>
  </xs:complexType>  
  
  <xs:complexType name="DTEType">
    <xs:sequence>
      <xs:element name="CedentePrestatoreDTE"      type="CedentePrestatoreDTEType"                                     />
      <xs:element name="CessionarioCommittenteDTE" type="CessionarioCommittenteDTEType" minOccurs="1" maxOccurs="1000" />
      <xs:element name="Rettifica"                 type="RettificaType"                 minOccurs="0"                  />
    </xs:sequence>
  </xs:complexType>
  
  <xs:complexType name="DTRType">
    <xs:sequence>
      <xs:element name="CessionarioCommittenteDTR" type="CessionarioCommittenteDTRType"                                />
      <xs:element name="CedentePrestatoreDTR"      type="CedentePrestatoreDTRType"      minOccurs="1" maxOccurs="1000" />
      <xs:element name="Rettifica"                 type="RettificaType"                 minOccurs="0"                  />
    </xs:sequence>
  </xs:complexType>
  
  <xs:complexType name="ANNType">
    <xs:sequence>
      <xs:element name="IdFile"                    type="String18Type" />
      <xs:element name="Posizione"                 type="PosizioneType"                 minOccurs="0" />
    </xs:sequence>
  </xs:complexType>  
  
  <xs:complexType name="CedentePrestatoreDTEType">
    <xs:annotation><xs:documentation>Blocco relativo ai dati del Cedente / Prestatore</xs:documentation></xs:annotation>
    <xs:sequence>
      <xs:element name="IdentificativiFiscali"   type="IdentificativiFiscaliITType"               />
      <xs:element name="AltriDatiIdentificativi" type="AltriDatiIdentificativiITType" minOccurs="0" />
    </xs:sequence>   
  </xs:complexType>  
  
  <xs:annotation><xs:documentation>Blocco relativo ai dati del Cedente / Prestatore</xs:documentation></xs:annotation>
  <xs:complexType name="CedentePrestatoreDTRType">
    <xs:sequence>
      <xs:element name="IdentificativiFiscali"   type="IdentificativiFiscaliType"        minOccurs="0"    />
      <xs:element name="AltriDatiIdentificativi" type="AltriDatiIdentificativiType"      minOccurs="0"    />
      <xs:element name="DatiFatturaBodyDTR"      type="DatiFatturaBodyDTRType"           maxOccurs="1000" />
    </xs:sequence>   
  </xs:complexType>  
  
  <xs:complexType name="CessionarioCommittenteDTEType">
    <xs:annotation><xs:documentation>Blocco relativo ai dati del Cessionario / Committente</xs:documentation></xs:annotation>
    <xs:sequence>
      <xs:element name="IdentificativiFiscali"   type="IdentificativiFiscaliNoIVAType"   minOccurs="0"    />
      <xs:element name="AltriDatiIdentificativi" type="AltriDatiIdentificativiType"      minOccurs="0"    />
      <xs:element name="DatiFatturaBodyDTE"      type="DatiFatturaBodyDTEType"           maxOccurs="1000" />
    </xs:sequence>
  </xs:complexType>
    
  <xs:complexType name="CessionarioCommittenteDTRType">
    <xs:annotation><xs:documentation>Blocco relativo ai dati del Cessionario / Committente</xs:documentation></xs:annotation>
    <xs:sequence>
      <xs:element name="IdentificativiFiscali"   type="IdentificativiFiscaliITType"               />
      <xs:element name="AltriDatiIdentificativi" type="AltriDatiIdentificativiITType" minOccurs="0" />
    </xs:sequence>
  </xs:complexType>
    
  <xs:complexType name="DatiFatturaBodyDTEType">
    <xs:sequence>
      <xs:element name="DatiGenerali"  type="DatiGeneraliDTEType"                   />
      <xs:element name="DatiRiepilogo" type="DatiRiepilogoType" maxOccurs="1000"    />
    </xs:sequence>
  </xs:complexType> 
  
  <xs:complexType name="DatiFatturaBodyDTRType">
    <xs:sequence>
      <xs:element name="DatiGenerali"  type="DatiGeneraliDTRType"                  />
      <xs:element name="DatiRiepilogo" type="DatiRiepilogoType"   maxOccurs="1000" />
    </xs:sequence>
  </xs:complexType> 
    
  <xs:complexType name="RettificaType">
    <xs:sequence>
      <xs:element name="IdFile"                    type="String18Type"  />
      <xs:element name="Posizione"                 type="PosizioneType" />
    </xs:sequence>
  </xs:complexType>
  
  <xs:complexType name="IdentificativiFiscaliType">
    <xs:sequence>
      <xs:element name="IdFiscaleIVA"  type="IdFiscaleType"                   />
      <xs:element name="CodiceFiscale" type="CodiceFiscaleType" minOccurs="0" />
    </xs:sequence>
  </xs:complexType>  
  
  <xs:complexType name="IdentificativiFiscaliITType">
    <xs:sequence>
      <xs:element name="IdFiscaleIVA"  type="IdFiscaleITType"                 />
      <xs:element name="CodiceFiscale" type="CodiceFiscaleType" minOccurs="0" />
    </xs:sequence>
  </xs:complexType>  
  
  <xs:complexType name="IdentificativiFiscaliNoIVAType">
    <xs:sequence>
      <xs:element name="IdFiscaleIVA"  type="IdFiscaleType"     minOccurs="0" />
      <xs:element name="CodiceFiscale" type="CodiceFiscaleType" minOccurs="0" />
    </xs:sequence>
  </xs:complexType>      
 
  <xs:complexType name="AltriDatiIdentificativiITType">
    <xs:sequence>
      <xs:element name="Denominazione"         type="String80LatinType"           minOccurs="0" />
      <xs:element name="Nome"                  type="String60LatinType"           minOccurs="0" />
      <xs:element name="Cognome"               type="String60LatinType"           minOccurs="0" />
      <xs:element name="Sede"                  type="IndirizzoType"               minOccurs="0" />
	  <xs:element name="StabileOrganizzazione" type="IndirizzoType"               minOccurs="0" />
	  <xs:element name="RappresentanteFiscale" type="RappresentanteFiscaleITType" minOccurs="0" />
    </xs:sequence>
  </xs:complexType>

  <xs:complexType name="AltriDatiIdentificativiType">
    <xs:sequence>
      <xs:element name="Denominazione"         type="String80LatinType"           minOccurs="0" />
      <xs:element name="Nome"                  type="String60LatinType"           minOccurs="0" />
      <xs:element name="Cognome"               type="String60LatinType"           minOccurs="0" />
      <xs:element name="Sede"                  type="IndirizzoType"               minOccurs="0" />
	  <xs:element name="StabileOrganizzazione" type="IndirizzoType"               minOccurs="0" />
	  <xs:element name="RappresentanteFiscale" type="RappresentanteFiscaleType" minOccurs="0" />
    </xs:sequence>
  </xs:complexType>
     
  <xs:complexType name="IndirizzoType">
    <xs:sequence>
      <xs:element name="Indirizzo"    type="String60LatinType"   minOccurs="0" />
      <xs:element name="NumeroCivico" type="NumeroCivicoType"    minOccurs="0" />
      <xs:element name="CAP"          type="CAPType"             minOccurs="0" />
      <xs:element name="Comune"       type="String60LatinType"   minOccurs="0" />
      <xs:element name="Provincia"    type="ProvinciaType"       minOccurs="0" />
      <xs:element name="Nazione"      type="NazioneType"         minOccurs="0" />
    </xs:sequence>
  </xs:complexType> 
  
  <xs:complexType name="RappresentanteFiscaleType">
    <xs:sequence>
      <xs:element name="IdFiscaleIVA"  type="IdFiscaleType"      minOccurs="0" /> 
      <xs:element name="Denominazione" type="String80LatinType"  minOccurs="0" />
      <xs:element name="Nome"          type="String60LatinType"  minOccurs="0" />
      <xs:element name="Cognome"       type="String60LatinType"  minOccurs="0" />
    </xs:sequence>
  </xs:complexType>  
  
  <xs:complexType name="RappresentanteFiscaleITType">
    <xs:sequence>
      <xs:element name="IdFiscaleIVA"  type="IdFiscaleITType"    minOccurs="0" /> 
      <xs:element name="Denominazione" type="String80LatinType"  minOccurs="0" />
      <xs:element name="Nome"          type="String60LatinType"  minOccurs="0" />
      <xs:element name="Cognome"       type="String60LatinType"  minOccurs="0" />
    </xs:sequence>
  </xs:complexType>  
  
  <xs:complexType name="DatiGeneraliDTEType">
    <xs:sequence>
      <xs:element name="TipoDocumento" type="TipoDocumentoType"  />
      <xs:element name="Data"          type="DataFatturaType"    />
      <xs:element name="Numero"        type="String20Type"       />
    </xs:sequence>
  </xs:complexType>    
  
  <xs:complexType name="DatiGeneraliDTRType">
    <xs:sequence>
      <xs:element name="TipoDocumento"     type="TipoDocumentoType"               />
      <xs:element name="Data"              type="DataFatturaType"   minOccurs="0" />
      <xs:element name="Numero"            type="String20Type"                    />
      <xs:element name="DataRegistrazione" type="DataFatturaType"                 />
    </xs:sequence>
  </xs:complexType>    
  
  <xs:complexType name="DatiRiepilogoType">
    <xs:sequence>
      <xs:element name="ImponibileImporto" type="Amount2DecimalType"                  />
      <xs:element name="DatiIVA"           type="DatiIVAType"                         />
      <xs:element name="Natura"            type="NaturaType"            minOccurs="0" />
      <xs:element name="Detraibile"        type="RateType"              minOccurs="0" />
      <xs:element name="Deducibile"        type="DeducibileType"        minOccurs="0" />
      <xs:element name="EsigibilitaIVA"    type="EsigibilitaIVAType"    minOccurs="0" />
    </xs:sequence>
  </xs:complexType>  
  
  <xs:complexType name="DatiIVAType">
    <xs:sequence>
      <xs:element name="Imposta"  type="Amount2DecimalType" minOccurs="0" />
      <xs:element name="Aliquota" type="RateType"           minOccurs="0" />
    </xs:sequence>
  </xs:complexType> 
    
  <xs:complexType name="IdFiscaleType">
	<xs:sequence>
	  <xs:element name="IdPaese"  type="NazioneType" />
	  <xs:element name="IdCodice" type="CodiceType"  />
	</xs:sequence>
  </xs:complexType>
    
  <xs:complexType name="IdFiscaleITType">
	<xs:sequence>
	  <xs:element name="IdPaese"  type="NazioneITType" />
	  <xs:element name="IdCodice" type="CodiceIvaType" />
	</xs:sequence>
  </xs:complexType>

  <xs:simpleType name="CodiceFiscaleType">
    <xs:restriction base="xs:normalizedString">
      <xs:pattern value="[A-Z0-9]{11,16}" />
    </xs:restriction>
  </xs:simpleType>
  
  <xs:simpleType name="NazioneType">
    <xs:restriction base="xs:string">
      <xs:pattern value="[A-Z]{2}" />
    </xs:restriction>
  </xs:simpleType>
  
  <xs:simpleType name="NazioneITType">
    <xs:restriction base="xs:string">
      <xs:length value="2" />
      <xs:enumeration value="IT">
        <xs:annotation><xs:documentation>Italia</xs:documentation></xs:annotation>
      </xs:enumeration>
    </xs:restriction>
  </xs:simpleType>

  <xs:simpleType name="CodiceType">
    <xs:restriction base="xs:normalizedString">
      <xs:minLength value="1" />
      <xs:maxLength value="28" />
    </xs:restriction>
  </xs:simpleType>

  <xs:simpleType name="CodiceIvaType">
    <xs:restriction base="xs:normalizedString">
      <xs:minLength value="1" />
      <xs:maxLength value="11" />
    </xs:restriction>
  </xs:simpleType>  
  
  <xs:simpleType name="NumeroCivicoType">
    <xs:restriction base="xs:normalizedString">
      <xs:pattern value="(\p{IsBasicLatin}{1,8})" />
    </xs:restriction>
  </xs:simpleType>

  <xs:simpleType name="CAPType">
    <xs:restriction base="xs:normalizedString">
      <xs:pattern value="(\p{IsBasicLatin}{1,5})" />
    </xs:restriction>
  </xs:simpleType>

  <xs:simpleType name="ProvinciaType">
    <xs:restriction base="xs:string">
      <xs:pattern value="[A-Z]{2}" />
    </xs:restriction>
  </xs:simpleType>
  
  <xs:simpleType name="TipoDocumentoType">
    <xs:restriction base="xs:string">
      <xs:length value="4" />
      <xs:enumeration value="TD01">
        <xs:annotation><xs:documentation>Fattura</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="TD04">
        <xs:annotation><xs:documentation>Nota di credito</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="TD05">
        <xs:annotation><xs:documentation>Nota di debito</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="TD07">
        <xs:annotation><xs:documentation>Fattura semplificata</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="TD08">
        <xs:annotation><xs:documentation>Nota di credito semplificata</xs:documentation></xs:annotation>
      </xs:enumeration>
	  <xs:enumeration value="TD10">
        <xs:annotation><xs:documentation>Acquisto beni intra</xs:documentation></xs:annotation>
      </xs:enumeration>
	  <xs:enumeration value="TD11">
        <xs:annotation><xs:documentation>Acquisto servizi intra</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="TD12">
        <xs:annotation><xs:documentation>Documento riepilogativo (art. 6, DPR 695/1996)</xs:documentation></xs:annotation>
      </xs:enumeration>
    </xs:restriction>
  </xs:simpleType>
  
  <xs:simpleType name="DataFatturaType">
    <xs:restriction base="xs:date">
      <xs:minInclusive value="1970-01-01" />
      <xs:whiteSpace value="collapse"/>
    </xs:restriction>
  </xs:simpleType>
  
  <xs:simpleType name="PosizioneType">
    <xs:restriction base="xs:integer">
      <xs:minInclusive value="1" />
      <xs:maxInclusive value="9999999" />
      <xs:whiteSpace value="collapse"/>
    </xs:restriction>
  </xs:simpleType>  
  
  <xs:simpleType name="CaricaType">
    <xs:restriction base="xs:integer">
      <xs:minInclusive value="1" />
      <xs:maxInclusive value="15" />
      <xs:whiteSpace value="collapse"/>
    </xs:restriction>
  </xs:simpleType>  
  
  <!-- STRINGHE -->
  <xs:simpleType name="String10Type">
    <xs:restriction base="xs:normalizedString">
      <xs:pattern value="(\p{IsBasicLatin}{1,10})" />
    </xs:restriction>
  </xs:simpleType>
  
  <xs:simpleType name="String18Type">
    <xs:restriction base="xs:normalizedString">
      <xs:pattern value="(\p{IsBasicLatin}{1,18})" />
    </xs:restriction>
  </xs:simpleType>
  
  <xs:simpleType name="String20Type">
    <xs:restriction base="xs:normalizedString">
      <xs:pattern value="(\p{IsBasicLatin}{1,20})" />
    </xs:restriction>
  </xs:simpleType>
    
  <xs:simpleType name="String60LatinType">
    <xs:restriction base="xs:normalizedString">
      <xs:pattern value="[\p{IsBasicLatin}\p{IsLatin-1Supplement}]{1,60}" />
    </xs:restriction>
  </xs:simpleType>

  <xs:simpleType name="String80LatinType">
    <xs:restriction base="xs:normalizedString">
      <xs:pattern value="[\p{IsBasicLatin}\p{IsLatin-1Supplement}]{1,80}" />
    </xs:restriction>
  </xs:simpleType>
  
  <xs:simpleType name="VersioneType">
    <xs:restriction base="xs:string">
      <xs:length value="5" />      
	  <xs:enumeration value="DAT20">
	    <xs:annotation><xs:documentation>Dati fatture versione 2.1</xs:documentation></xs:annotation>
	  </xs:enumeration>
    </xs:restriction>
  </xs:simpleType>
  
  <xs:simpleType name="NaturaType">
    <xs:restriction base="xs:string">
      <xs:enumeration value="N1">
        <xs:annotation><xs:documentation>Escluse ex. art. 15</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="N2">
        <xs:annotation><xs:documentation>Non soggette</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="N3">
        <xs:annotation><xs:documentation>Non Imponibili</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="N4">
        <xs:annotation><xs:documentation>Esenti</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="N5">
        <xs:annotation><xs:documentation>Regime del margine</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="N6">
        <xs:annotation><xs:documentation>Inversione contabile (reverse charge)</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="N7">
        <xs:annotation>
                       <xs:documentation> IVA assolta in altro stato UE
	                                      (vendite a distanza ex art. 40 c. 3 e 4 e art. 41 c. 1 lett. b,  DL 331/93; 
	                                       prestazione di servizi di telecomunicazioni, tele-radiodiffusione ed elettronici 
	                                       ex art. 7-sexies lett. f, g, art. 74-sexies DPR 633/72)
                       </xs:documentation></xs:annotation>
      </xs:enumeration>
    </xs:restriction>
  </xs:simpleType>

  <xs:simpleType name="DeducibileType">
    <xs:restriction base="xs:string">
      <xs:length value="2" />
      <xs:enumeration value="SI">
        <xs:annotation><xs:documentation>Spesa deducibile</xs:documentation></xs:annotation>
      </xs:enumeration>
    </xs:restriction>
  </xs:simpleType>
  
  
  <xs:simpleType name="EsigibilitaIVAType">
    <xs:restriction base="xs:string">
      <xs:minLength value="1" />
      <xs:maxLength value="1" />
      <xs:enumeration value="D">
        <xs:annotation>
          <xs:documentation>esigibilità differita</xs:documentation>
        </xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="I">
        <xs:annotation>
          <xs:documentation>esigibilità immediata</xs:documentation>
        </xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="S">
        <xs:annotation>
          <xs:documentation>scissione dei pagamenti</xs:documentation>
        </xs:annotation>
      </xs:enumeration>
    </xs:restriction>
  </xs:simpleType>
  
   <xs:simpleType name="RateType">
    <xs:restriction base="xs:decimal">
      <xs:maxInclusive value="100.00" />
      <xs:pattern value="[0-9]{1,3}\.[0-9]{2}" />
      <xs:whiteSpace value="collapse"/>
    </xs:restriction>
  </xs:simpleType>  
  
  <!-- NUMERI -->
  <xs:simpleType name="Amount2DecimalType">
    <xs:restriction base="xs:decimal">
      <xs:pattern value="[\-]?[0-9]{1,11}\.[0-9]{2}" />
      <xs:whiteSpace value="collapse"/>
    </xs:restriction>
  </xs:simpleType>
  
</xs:schema>')
 insert #tA values ('10', 'fornituraIvp_2018_v1', '<?xml version="1.0" encoding="UTF-8"?>
<!-- edited with XMLSpy v2017 sp2 (x64) (http://www.altova.com) by rsiino 
       (Sogei S.p.A.) -->
<xs:schema xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:cm="urn:www.agenziaentrate.gov.it:specificheTecniche:common" xmlns:sc="urn:www.agenziaentrate.gov.it:specificheTecniche:sco:common" xmlns:iv="urn:www.agenziaentrate.gov.it:specificheTecniche:sco:ivp" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" targetNamespace="urn:www.agenziaentrate.gov.it:specificheTecniche:sco:ivp" elementFormDefault="qualified" attributeFormDefault="unqualified" version="1.0">
	<xs:import namespace="http://www.w3.org/2000/09/xmldsig#" schemaLocation="xmldsig-core-schema.xsd"/>
	<xs:annotation>
		<xs:documentation xml:lang="it"><![CDATA[
             Versione 1.0 - 13/02/16
             ]]></xs:documentation>
	</xs:annotation>
	<xs:include schemaLocation="intestazioneIvp_2018_v1.xsd"/>
	<xs:include schemaLocation="comunicazioneIvp_2018_v1.xsd"/>
	<xs:element name="Fornitura">
		<xs:complexType>
			<xs:sequence>
				<xs:element name="Intestazione" type="iv:Intestazione_IVP_Type"/>
				<xs:element name="Comunicazione" type="iv:Comunicazione_IVP_Type"/>
				<xs:element ref="ds:Signature" minOccurs="0"/>
			</xs:sequence>
		</xs:complexType>
	</xs:element>
</xs:schema>
')
 insert #tA values ('11', 'intestazioneIvp_2018_v1', '<?xml version="1.0" encoding="UTF-8"?>
<!-- edited with XMLSpy v2017 sp2 (x64) (http://www.altova.com) by rsiino (Sogei S.p.A.) -->
<xs:schema xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:cm="urn:www.agenziaentrate.gov.it:specificheTecniche:common" xmlns:sc="urn:www.agenziaentrate.gov.it:specificheTecniche:sco:common" xmlns:iv="urn:www.agenziaentrate.gov.it:specificheTecniche:sco:ivp" xmlns:ns1="www.agenziaentrate.gov.it:specificheTecniche:telent:v1" targetNamespace="urn:www.agenziaentrate.gov.it:specificheTecniche:sco:ivp" elementFormDefault="qualified" attributeFormDefault="unqualified" version="1.0">
	<xs:annotation>
		<xs:documentation xml:lang="it"><![CDATA[
		Versione 1.0 - 13/02/16
		]]></xs:documentation>
	</xs:annotation>
	<xs:import namespace="urn:www.agenziaentrate.gov.it:specificheTecniche:common" schemaLocation="../../common/fornitura_v3.xsd"/>
	<xs:element name="Intestazione"/>
	<xs:complexType name="Intestazione_IVP_Type">
		<xs:sequence>
			<xs:element name="CodiceFornitura">
				<xs:simpleType>
					<xs:restriction base="cm:DatoAN_Type">
						<xs:enumeration value="IVP18"/>
					</xs:restriction>
				</xs:simpleType>
			</xs:element>
			<xs:element name="CodiceFiscaleDichiarante" type="cm:DatoCF_Type" minOccurs="0"/>
			<xs:element name="CodiceCarica" minOccurs="0">
				<xs:simpleType>
					<xs:restriction base="cm:DatoNP_Type">
						<xs:enumeration value="1"/>
						<xs:enumeration value="2"/>
						<xs:enumeration value="3"/>
						<xs:enumeration value="4"/>
						<xs:enumeration value="5"/>
						<xs:enumeration value="6"/>
						<xs:enumeration value="7"/>
						<xs:enumeration value="8"/>
						<xs:enumeration value="9"/>
						<xs:enumeration value="11"/>
						<xs:enumeration value="12"/>
						<xs:enumeration value="13"/>
						<xs:enumeration value="14"/>
						<xs:enumeration value="15"/>
					</xs:restriction>
				</xs:simpleType>
			</xs:element>
			<xs:element name="IdSistema" type="cm:DatoCF_Type" minOccurs="0"/>
		</xs:sequence>
	</xs:complexType>
</xs:schema>
')
 insert #tA values ('12', 'comunicazioneIvp_2018_v1', '<?xml version="1.0" encoding="UTF-8"?>
<!-- edited with XMLSpy v2017 sp2 (x64) (http://www.altova.com) by rsiino (Sogei S.p.A.) -->
<xs:schema xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:cm="urn:www.agenziaentrate.gov.it:specificheTecniche:common" xmlns:sc="urn:www.agenziaentrate.gov.it:specificheTecniche:sco:common" xmlns:iv="urn:www.agenziaentrate.gov.it:specificheTecniche:sco:ivp" xmlns:ns1="www.agenziaentrate.gov.it:specificheTecniche:telent:v1" targetNamespace="urn:www.agenziaentrate.gov.it:specificheTecniche:sco:ivp" elementFormDefault="qualified" attributeFormDefault="unqualified" version="1.0">
	<xs:annotation>
		<xs:documentation xml:lang="it"><![CDATA[
		Versione 1.0 - 13/02/16]]></xs:documentation>
	</xs:annotation>
	<xs:import namespace="urn:www.agenziaentrate.gov.it:specificheTecniche:common" schemaLocation="../../common/fornitura_v3.xsd"/>
	<xs:element name="Comunicazione" type="iv:Comunicazione_IVP_Type"/>
	<xs:complexType name="Comunicazione_IVP_Type">
		<xs:complexContent>
			<xs:extension base="cm:Documento_Type">
				<xs:sequence>
					<xs:element name="Frontespizio" type="iv:Frontespizio_IVP_Type"/>
					<xs:element name="DatiContabili" type="iv:DatiContabili_IVP_Type"/>
				</xs:sequence>
			</xs:extension>
		</xs:complexContent>
	</xs:complexType>
	<xs:complexType name="Frontespizio_IVP_Type">
		<xs:sequence>
			<xs:element name="CodiceFiscale" type="cm:DatoCF_Type"/>
			<xs:element name="AnnoImposta" type="cm:DatoDA_Type"/>
			<xs:element name="PartitaIVA" type="cm:DatoPI_Type"/>
			<xs:element name="PIVAControllante" type="cm:DatoPI_Type" minOccurs="0"/>
			<xs:element name="UltimoMese" minOccurs="0">
				<xs:simpleType>
					<xs:restriction base="cm:DatoNP_Type">
						<xs:enumeration value="1"/>
						<xs:enumeration value="2"/>
						<xs:enumeration value="3"/>
						<xs:enumeration value="4"/>
						<xs:enumeration value="5"/>
						<xs:enumeration value="6"/>
						<xs:enumeration value="7"/>
						<xs:enumeration value="8"/>
						<xs:enumeration value="9"/>
						<xs:enumeration value="10"/>
						<xs:enumeration value="11"/>
						<xs:enumeration value="12"/>
						<xs:enumeration value="13"/>
						<xs:enumeration value="99"/>
					</xs:restriction>
				</xs:simpleType>
			</xs:element>
			<xs:element name="LiquidazioneGruppo" type="cm:DatoCB_Type" minOccurs="0"/>
			<xs:element name="CFDichiarante" type="cm:DatoCF_Type" minOccurs="0"/>
			<xs:element name="CodiceCaricaDichiarante" minOccurs="0">
				<xs:simpleType>
					<xs:restriction base="cm:DatoNP_Type">
						<xs:enumeration value="1"/>
						<xs:enumeration value="2"/>
						<xs:enumeration value="3"/>
						<xs:enumeration value="4"/>
						<xs:enumeration value="5"/>
						<xs:enumeration value="6"/>
						<xs:enumeration value="7"/>
						<xs:enumeration value="8"/>
						<xs:enumeration value="9"/>
						<xs:enumeration value="11"/>
						<xs:enumeration value="12"/>
						<xs:enumeration value="13"/>
						<xs:enumeration value="14"/>
						<xs:enumeration value="15"/>
					</xs:restriction>
				</xs:simpleType>
			</xs:element>
			<xs:element name="CodiceFiscaleSocieta" type="cm:DatoCN_Type" minOccurs="0"/>
			<xs:element name="FirmaDichiarazione" type="cm:DatoCB_Type"/>
			<xs:element name="CFIntermediario" type="cm:DatoCF_Type" minOccurs="0"/>
			<xs:element name="ImpegnoPresentazione" minOccurs="0">
				<xs:simpleType>
					<xs:restriction base="cm:DatoN1_Type">
						<xs:enumeration value="1"/>
						<xs:enumeration value="2"/>
					</xs:restriction>
				</xs:simpleType>
			</xs:element>
			<xs:element name="DataImpegno" type="cm:DatoDT_Type" minOccurs="0"/>
			<xs:element name="FirmaIntermediario" type="cm:DatoCB_Type" minOccurs="0"/>
			<xs:element name="FlagConferma" type="cm:DatoCB_Type" minOccurs="0"/>
			<xs:element name="IdentificativoProdSoftware" type="cm:DatoAN_Type" minOccurs="0"/>
		</xs:sequence>
	</xs:complexType>
	<xs:complexType name="DatiContabili_IVP_Type">
		<xs:sequence>
			<xs:element name="Modulo" maxOccurs="5">
				<xs:complexType>
					<xs:sequence>
						<xs:element name="NumeroModulo">
							<xs:simpleType>
								<xs:restriction base="cm:DatoN1_Type">
									<xs:enumeration value="1"/>
									<xs:enumeration value="2"/>
									<xs:enumeration value="3"/>
									<xs:enumeration value="4"/>
									<xs:enumeration value="5"/>
								</xs:restriction>
							</xs:simpleType>
						</xs:element>
						<xs:element name="Mese" minOccurs="0">
							<xs:simpleType>
								<xs:restriction base="cm:DatoNP_Type">
									<xs:enumeration value="1"/>
									<xs:enumeration value="2"/>
									<xs:enumeration value="3"/>
									<xs:enumeration value="4"/>
									<xs:enumeration value="5"/>
									<xs:enumeration value="6"/>
									<xs:enumeration value="7"/>
									<xs:enumeration value="8"/>
									<xs:enumeration value="9"/>
									<xs:enumeration value="10"/>
									<xs:enumeration value="11"/>
									<xs:enumeration value="12"/>
								</xs:restriction>
							</xs:simpleType>
						</xs:element>
						<xs:element name="Trimestre" minOccurs="0">
							<xs:simpleType>
								<xs:restriction base="cm:DatoN1_Type">
									<xs:enumeration value="1"/>
									<xs:enumeration value="2"/>
									<xs:enumeration value="3"/>
									<xs:enumeration value="4"/>
									<xs:enumeration value="5"/>
								</xs:restriction>
							</xs:simpleType>
						</xs:element>
						<xs:element name="Subfornitura" type="cm:DatoCB_Type" minOccurs="0"/>
						<xs:element name="EventiEccezionali" type="iv:Eventi_Ecc_Type" minOccurs="0"/>
						<xs:element name="OperazioniStraordinarie" type="cm:DatoCB_Type" minOccurs="0"/>
						<xs:element name="TotaleOperazioniAttive" type="iv:DatoVN_Type" minOccurs="0"/>
						<xs:element name="TotaleOperazioniPassive" type="iv:DatoVN_Type" minOccurs="0"/>
						<xs:element name="IvaEsigibile" type="iv:DatoVN_Type" minOccurs="0"/>
						<xs:element name="IvaDetratta" type="iv:DatoVN_Type" minOccurs="0"/>
						<xs:element name="IvaDovuta" type="cm:DatoVP_Type" minOccurs="0"/>
						<xs:element name="IvaCredito" type="cm:DatoVP_Type" minOccurs="0"/>
						<xs:element name="DebitoPrecedente" type="cm:DatoVP_Type" minOccurs="0"/>
						<xs:element name="CreditoPeriodoPrecedente" type="cm:DatoVP_Type" minOccurs="0"/>
						<xs:element name="CreditoAnnoPrecedente" type="iv:DatoVN_Type" minOccurs="0"/>
						<xs:element name="VersamentiAutoUE" type="cm:DatoVP_Type" minOccurs="0"/>
						<xs:element name="CreditiImposta" type="cm:DatoVP_Type" minOccurs="0"/>
						<xs:element name="InteressiDovuti" type="cm:DatoVP_Type" minOccurs="0"/>
						<xs:element name="Metodo" minOccurs="0">
							<xs:simpleType>
								<xs:restriction base="cm:DatoN1_Type">
									<xs:enumeration value="1"/>
									<xs:enumeration value="2"/>
									<xs:enumeration value="3"/>
									<xs:enumeration value="4"/>
								</xs:restriction>
							</xs:simpleType>
						</xs:element>
						<xs:element name="Acconto" type="cm:DatoVP_Type" minOccurs="0"/>
						<xs:element name="ImportoDaVersare" type="cm:DatoVP_Type" minOccurs="0"/>
						<xs:element name="ImportoACredito" type="cm:DatoVP_Type" minOccurs="0"/>
					</xs:sequence>
				</xs:complexType>
			</xs:element>
		</xs:sequence>
	</xs:complexType>
	<xs:simpleType name="Eventi_Ecc_Type">
		<xs:restriction base="xs:string">
			<xs:enumeration value="1"/>
			<xs:enumeration value="9"/>
		</xs:restriction>
	</xs:simpleType>
	<xs:simpleType name="DatoVN_Type">
		<xs:annotation>
			<xs:documentation>Tipo semplice che identifica numeri positivi con 2 cifre decimali. La lunghezza massima prevista è di 16 caratteri, il separatore decimale previsto è la virgola.</xs:documentation>
		</xs:annotation>
		<xs:restriction base="xs:string">
			<xs:maxLength value="16"/>
			<xs:pattern value="[\-]{0,1}[0-9]+,[0-9]{2}"/>
		</xs:restriction>
	</xs:simpleType>
</xs:schema>
')
 insert #tA values ('13', 'DatiFatturav2.1', '<?xml version="1.0" encoding="utf-8"?>
<xs:schema xmlns:xs="http://www.w3.org/2001/XMLSchema" 
	xmlns:ds="http://www.w3.org/2000/09/xmldsig#" 
	xmlns="http://ivaservizi.agenziaentrate.gov.it/docs/xsd/fatture/v2.0" 
	targetNamespace="http://ivaservizi.agenziaentrate.gov.it/docs/xsd/fatture/v2.0" 
	version="2.1">

  <xs:import namespace="http://www.w3.org/2000/09/xmldsig#" schemaLocation="http://www.w3.org/TR/2002/REC-xmldsig-core-20020212/xmldsig-core-schema.xsd" />
    
  <!-- =================================================================== -->
  <!-- ELEMENTI                                                            -->
  <!-- =================================================================== -->
  <xs:element name="DatiFattura" type="DatiFatturaType">
    <xs:annotation>
      <xs:documentation>XML schema fatture emesse e ricevute ex D.Lgs. 127/205 (art.1, c.3) 2.1</xs:documentation>
    </xs:annotation>
  </xs:element>  
  
  <!-- =================================================================== -->
  <!-- TIPI                                                                -->
  <!-- =================================================================== -->
  <xs:complexType name="DatiFatturaType">
    <xs:sequence>
      <xs:element name="DatiFatturaHeader"    type="DatiFatturaHeaderType"      minOccurs="0" />
	  <xs:choice>
	    <xs:element name="DTE" type="DTEType" />
	    <xs:element name="DTR" type="DTRType" />
	    <xs:element name="ANN" type="ANNType" />
      </xs:choice>
      <xs:element ref ="ds:Signature" minOccurs="0" />
    </xs:sequence>
    <xs:attribute name="versione" type="VersioneType" use="required" />
  </xs:complexType>  
  
  <xs:complexType name="DatiFatturaHeaderType">
    <xs:sequence>
      <xs:element name="ProgressivoInvio" type="String10Type"                minOccurs="0" />
      <xs:element name="Dichiarante"      type="DichiaranteType"             minOccurs="0" />
      <xs:element name="IdSistema"        type="CodiceFiscaleType"           minOccurs="0" />
      <xs:element name="SpazioDatiFattura" type="xs:normalizedString" minOccurs="0" />
    </xs:sequence>
  </xs:complexType>     
  
  <xs:complexType name="DichiaranteType">
    <xs:sequence>
      <xs:element name="CodiceFiscale"             type="CodiceFiscaleType" />
      <xs:element name="Carica"                    type="CaricaType"        />
    </xs:sequence>
  </xs:complexType>  
  
  <xs:complexType name="DTEType">
    <xs:sequence>
      <xs:element name="CedentePrestatoreDTE"      type="CedentePrestatoreDTEType"                                     />
      <xs:element name="CessionarioCommittenteDTE" type="CessionarioCommittenteDTEType" minOccurs="1" maxOccurs="1000" />
      <xs:element name="Rettifica"                 type="RettificaType"                 minOccurs="0"                  />
    </xs:sequence>
  </xs:complexType>
  
  <xs:complexType name="DTRType">
    <xs:sequence>
      <xs:element name="CessionarioCommittenteDTR" type="CessionarioCommittenteDTRType"                                />
      <xs:element name="CedentePrestatoreDTR"      type="CedentePrestatoreDTRType"      minOccurs="1" maxOccurs="1000" />
      <xs:element name="Rettifica"                 type="RettificaType"                 minOccurs="0"                  />
    </xs:sequence>
  </xs:complexType>
  
  <xs:complexType name="ANNType">
    <xs:sequence>
      <xs:element name="IdFile"                    type="String18Type" />
      <xs:element name="Posizione"                 type="PosizioneType"                 minOccurs="0" />
    </xs:sequence>
  </xs:complexType>  
  
  <xs:complexType name="CedentePrestatoreDTEType">
    <xs:annotation><xs:documentation>Blocco relativo ai dati del Cedente / Prestatore</xs:documentation></xs:annotation>
    <xs:sequence>
      <xs:element name="IdentificativiFiscali"   type="IdentificativiFiscaliITType"               />
      <xs:element name="AltriDatiIdentificativi" type="AltriDatiIdentificativiITType" minOccurs="0" />
    </xs:sequence>   
  </xs:complexType>  
  
  <xs:annotation><xs:documentation>Blocco relativo ai dati del Cedente / Prestatore</xs:documentation></xs:annotation>
  <xs:complexType name="CedentePrestatoreDTRType">
    <xs:sequence>
      <xs:element name="IdentificativiFiscali"   type="IdentificativiFiscaliType"        minOccurs="0"    />
      <xs:element name="AltriDatiIdentificativi" type="AltriDatiIdentificativiType"      minOccurs="0"    />
      <xs:element name="DatiFatturaBodyDTR"      type="DatiFatturaBodyDTRType"           maxOccurs="1000" />
    </xs:sequence>   
  </xs:complexType>  
  
  <xs:complexType name="CessionarioCommittenteDTEType">
    <xs:annotation><xs:documentation>Blocco relativo ai dati del Cessionario / Committente</xs:documentation></xs:annotation>
    <xs:sequence>
      <xs:element name="IdentificativiFiscali"   type="IdentificativiFiscaliNoIVAType"   minOccurs="0"    />
      <xs:element name="AltriDatiIdentificativi" type="AltriDatiIdentificativiType"      minOccurs="0"    />
      <xs:element name="DatiFatturaBodyDTE"      type="DatiFatturaBodyDTEType"           maxOccurs="1000" />
    </xs:sequence>
  </xs:complexType>
    
  <xs:complexType name="CessionarioCommittenteDTRType">
    <xs:annotation><xs:documentation>Blocco relativo ai dati del Cessionario / Committente</xs:documentation></xs:annotation>
    <xs:sequence>
      <xs:element name="IdentificativiFiscali"   type="IdentificativiFiscaliITType"               />
      <xs:element name="AltriDatiIdentificativi" type="AltriDatiIdentificativiITType" minOccurs="0" />
    </xs:sequence>
  </xs:complexType>
    
  <xs:complexType name="DatiFatturaBodyDTEType">
    <xs:sequence>
      <xs:element name="DatiGenerali"  type="DatiGeneraliDTEType"                   />
      <xs:element name="DatiRiepilogo" type="DatiRiepilogoType" maxOccurs="1000"    />
    </xs:sequence>
  </xs:complexType> 
  
  <xs:complexType name="DatiFatturaBodyDTRType">
    <xs:sequence>
      <xs:element name="DatiGenerali"  type="DatiGeneraliDTRType"                  />
      <xs:element name="DatiRiepilogo" type="DatiRiepilogoType"   maxOccurs="1000" />
    </xs:sequence>
  </xs:complexType> 
    
  <xs:complexType name="RettificaType">
    <xs:sequence>
      <xs:element name="IdFile"                    type="String18Type"  />
      <xs:element name="Posizione"                 type="PosizioneType" />
    </xs:sequence>
  </xs:complexType>
  
  <xs:complexType name="IdentificativiFiscaliType">
    <xs:sequence>
      <xs:element name="IdFiscaleIVA"  type="IdFiscaleType"                   />
      <xs:element name="CodiceFiscale" type="CodiceFiscaleType" minOccurs="0" />
    </xs:sequence>
  </xs:complexType>  
  
  <xs:complexType name="IdentificativiFiscaliITType">
    <xs:sequence>
      <xs:element name="IdFiscaleIVA"  type="IdFiscaleITType"                 />
      <xs:element name="CodiceFiscale" type="CodiceFiscaleType" minOccurs="0" />
    </xs:sequence>
  </xs:complexType>  
  
  <xs:complexType name="IdentificativiFiscaliNoIVAType">
    <xs:sequence>
      <xs:element name="IdFiscaleIVA"  type="IdFiscaleType"     minOccurs="0" />
      <xs:element name="CodiceFiscale" type="CodiceFiscaleType" minOccurs="0" />
    </xs:sequence>
  </xs:complexType>      
 
  <xs:complexType name="AltriDatiIdentificativiITType">
    <xs:sequence>
      <xs:element name="Denominazione"         type="String80LatinType"           minOccurs="0" />
      <xs:element name="Nome"                  type="String60LatinType"           minOccurs="0" />
      <xs:element name="Cognome"               type="String60LatinType"           minOccurs="0" />
      <xs:element name="Sede"                  type="IndirizzoType"               minOccurs="0" />
	  <xs:element name="StabileOrganizzazione" type="IndirizzoType"               minOccurs="0" />
	  <xs:element name="RappresentanteFiscale" type="RappresentanteFiscaleITType" minOccurs="0" />
    </xs:sequence>
  </xs:complexType>

  <xs:complexType name="AltriDatiIdentificativiType">
    <xs:sequence>
      <xs:element name="Denominazione"         type="String80LatinType"           minOccurs="0" />
      <xs:element name="Nome"                  type="String60LatinType"           minOccurs="0" />
      <xs:element name="Cognome"               type="String60LatinType"           minOccurs="0" />
      <xs:element name="Sede"                  type="IndirizzoType"               minOccurs="0" />
	  <xs:element name="StabileOrganizzazione" type="IndirizzoType"               minOccurs="0" />
	  <xs:element name="RappresentanteFiscale" type="RappresentanteFiscaleType" minOccurs="0" />
    </xs:sequence>
  </xs:complexType>
     
  <xs:complexType name="IndirizzoType">
    <xs:sequence>
      <xs:element name="Indirizzo"    type="String60LatinType"   minOccurs="0" />
      <xs:element name="NumeroCivico" type="NumeroCivicoType"    minOccurs="0" />
      <xs:element name="CAP"          type="CAPType"             minOccurs="0" />
      <xs:element name="Comune"       type="String60LatinType"   minOccurs="0" />
      <xs:element name="Provincia"    type="ProvinciaType"       minOccurs="0" />
      <xs:element name="Nazione"      type="NazioneType"         minOccurs="0" />
    </xs:sequence>
  </xs:complexType> 
  
  <xs:complexType name="RappresentanteFiscaleType">
    <xs:sequence>
      <xs:element name="IdFiscaleIVA"  type="IdFiscaleType"      minOccurs="0" /> 
      <xs:element name="Denominazione" type="String80LatinType"  minOccurs="0" />
      <xs:element name="Nome"          type="String60LatinType"  minOccurs="0" />
      <xs:element name="Cognome"       type="String60LatinType"  minOccurs="0" />
    </xs:sequence>
  </xs:complexType>  
  
  <xs:complexType name="RappresentanteFiscaleITType">
    <xs:sequence>
      <xs:element name="IdFiscaleIVA"  type="IdFiscaleITType"    minOccurs="0" /> 
      <xs:element name="Denominazione" type="String80LatinType"  minOccurs="0" />
      <xs:element name="Nome"          type="String60LatinType"  minOccurs="0" />
      <xs:element name="Cognome"       type="String60LatinType"  minOccurs="0" />
    </xs:sequence>
  </xs:complexType>  
  
  <xs:complexType name="DatiGeneraliDTEType">
    <xs:sequence>
      <xs:element name="TipoDocumento" type="TipoDocumentoType"  />
      <xs:element name="Data"          type="DataFatturaType"    />
      <xs:element name="Numero"        type="String20Type"       />
    </xs:sequence>
  </xs:complexType>    
  
  <xs:complexType name="DatiGeneraliDTRType">
    <xs:sequence>
      <xs:element name="TipoDocumento"     type="TipoDocumentoType"               />
      <xs:element name="Data"              type="DataFatturaType"   minOccurs="0" />
      <xs:element name="Numero"            type="String20Type"                    />
      <xs:element name="DataRegistrazione" type="DataFatturaType"                 />
    </xs:sequence>
  </xs:complexType>    
  
  <xs:complexType name="DatiRiepilogoType">
    <xs:sequence>
      <xs:element name="ImponibileImporto" type="Amount2DecimalType"                  />
      <xs:element name="DatiIVA"           type="DatiIVAType"                         />
      <xs:element name="Natura"            type="NaturaType"            minOccurs="0" />
      <xs:element name="Detraibile"        type="RateType"              minOccurs="0" />
      <xs:element name="Deducibile"        type="DeducibileType"        minOccurs="0" />
      <xs:element name="EsigibilitaIVA"    type="EsigibilitaIVAType"    minOccurs="0" />
    </xs:sequence>
  </xs:complexType>  
  
  <xs:complexType name="DatiIVAType">
    <xs:sequence>
      <xs:element name="Imposta"  type="Amount2DecimalType" minOccurs="0" />
      <xs:element name="Aliquota" type="RateType"           minOccurs="0" />
    </xs:sequence>
  </xs:complexType> 
    
  <xs:complexType name="IdFiscaleType">
	<xs:sequence>
	  <xs:element name="IdPaese"  type="NazioneType" />
	  <xs:element name="IdCodice" type="CodiceType"  />
	</xs:sequence>
  </xs:complexType>
    
  <xs:complexType name="IdFiscaleITType">
	<xs:sequence>
	  <xs:element name="IdPaese"  type="NazioneITType" />
	  <xs:element name="IdCodice" type="CodiceIvaType" />
	</xs:sequence>
  </xs:complexType>

  <xs:simpleType name="CodiceFiscaleType">
    <xs:restriction base="xs:normalizedString">
      <xs:pattern value="[A-Z0-9]{11,16}" />
    </xs:restriction>
  </xs:simpleType>
  
  <xs:simpleType name="NazioneType">
    <xs:restriction base="xs:string">
      <xs:pattern value="[A-Z]{2}" />
    </xs:restriction>
  </xs:simpleType>
  
  <xs:simpleType name="NazioneITType">
    <xs:restriction base="xs:string">
      <xs:length value="2" />
      <xs:enumeration value="IT">
        <xs:annotation><xs:documentation>Italia</xs:documentation></xs:annotation>
      </xs:enumeration>
    </xs:restriction>
  </xs:simpleType>

  <xs:simpleType name="CodiceType">
    <xs:restriction base="xs:normalizedString">
      <xs:minLength value="1" />
      <xs:maxLength value="28" />
    </xs:restriction>
  </xs:simpleType>

  <xs:simpleType name="CodiceIvaType">
    <xs:restriction base="xs:normalizedString">
      <xs:minLength value="1" />
      <xs:maxLength value="11" />
    </xs:restriction>
  </xs:simpleType>  
  
  <xs:simpleType name="NumeroCivicoType">
    <xs:restriction base="xs:normalizedString">
      <xs:pattern value="(\p{IsBasicLatin}{1,8})" />
    </xs:restriction>
  </xs:simpleType>

  <xs:simpleType name="CAPType">
    <xs:restriction base="xs:normalizedString">
      <xs:pattern value="(\p{IsBasicLatin}{1,5})" />
    </xs:restriction>
  </xs:simpleType>

  <xs:simpleType name="ProvinciaType">
    <xs:restriction base="xs:string">
      <xs:pattern value="[A-Z]{2}" />
    </xs:restriction>
  </xs:simpleType>
  
  <xs:simpleType name="TipoDocumentoType">
    <xs:restriction base="xs:string">
      <xs:length value="4" />
      <xs:enumeration value="TD01">
        <xs:annotation><xs:documentation>Fattura</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="TD04">
        <xs:annotation><xs:documentation>Nota di credito</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="TD05">
        <xs:annotation><xs:documentation>Nota di debito</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="TD07">
        <xs:annotation><xs:documentation>Fattura semplificata</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="TD08">
        <xs:annotation><xs:documentation>Nota di credito semplificata</xs:documentation></xs:annotation>
      </xs:enumeration>
	  <xs:enumeration value="TD10">
        <xs:annotation><xs:documentation>Acquisto beni intra</xs:documentation></xs:annotation>
      </xs:enumeration>
	  <xs:enumeration value="TD11">
        <xs:annotation><xs:documentation>Acquisto servizi intra</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="TD12">
        <xs:annotation><xs:documentation>Documento riepilogativo (art. 6, DPR 695/1996)</xs:documentation></xs:annotation>
      </xs:enumeration>
    </xs:restriction>
  </xs:simpleType>
  
  <xs:simpleType name="DataFatturaType">
    <xs:restriction base="xs:date">
      <xs:minInclusive value="1970-01-01" />
      <xs:whiteSpace value="collapse"/>
    </xs:restriction>
  </xs:simpleType>
  
  <xs:simpleType name="PosizioneType">
    <xs:restriction base="xs:integer">
      <xs:minInclusive value="1" />
      <xs:maxInclusive value="9999999" />
      <xs:whiteSpace value="collapse"/>
    </xs:restriction>
  </xs:simpleType>  
  
  <xs:simpleType name="CaricaType">
    <xs:restriction base="xs:integer">
      <xs:minInclusive value="1" />
      <xs:maxInclusive value="15" />
      <xs:whiteSpace value="collapse"/>
    </xs:restriction>
  </xs:simpleType>  
  
  <!-- STRINGHE -->
  <xs:simpleType name="String10Type">
    <xs:restriction base="xs:normalizedString">
      <xs:pattern value="(\p{IsBasicLatin}{1,10})" />
    </xs:restriction>
  </xs:simpleType>
  
  <xs:simpleType name="String18Type">
    <xs:restriction base="xs:normalizedString">
      <xs:pattern value="(\p{IsBasicLatin}{1,18})" />
    </xs:restriction>
  </xs:simpleType>
  
  <xs:simpleType name="String20Type">
    <xs:restriction base="xs:normalizedString">
      <xs:pattern value="(\p{IsBasicLatin}{1,20})" />
    </xs:restriction>
  </xs:simpleType>
    
  <xs:simpleType name="String60LatinType">
    <xs:restriction base="xs:normalizedString">
      <xs:pattern value="[\p{IsBasicLatin}\p{IsLatin-1Supplement}]{1,60}" />
    </xs:restriction>
  </xs:simpleType>

  <xs:simpleType name="String80LatinType">
    <xs:restriction base="xs:normalizedString">
      <xs:pattern value="[\p{IsBasicLatin}\p{IsLatin-1Supplement}]{1,80}" />
    </xs:restriction>
  </xs:simpleType>
  
  <xs:simpleType name="VersioneType">
    <xs:restriction base="xs:string">
      <xs:length value="5" />      
	  <xs:enumeration value="DAT20">
	    <xs:annotation><xs:documentation>Dati fatture versione 2.1</xs:documentation></xs:annotation>
	  </xs:enumeration>
    </xs:restriction>
  </xs:simpleType>
  
  <xs:simpleType name="NaturaType">
    <xs:restriction base="xs:string">
      <xs:enumeration value="N1">
        <xs:annotation><xs:documentation>Escluse ex. art. 15</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="N2">
        <xs:annotation><xs:documentation>Non soggette</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="N3">
        <xs:annotation><xs:documentation>Non Imponibili</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="N4">
        <xs:annotation><xs:documentation>Esenti</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="N5">
        <xs:annotation><xs:documentation>Regime del margine</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="N6">
        <xs:annotation><xs:documentation>Inversione contabile (reverse charge)</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="N7">
        <xs:annotation>
                       <xs:documentation> IVA assolta in altro stato UE
	                                      (vendite a distanza ex art. 40 c. 3 e 4 e art. 41 c. 1 lett. b,  DL 331/93; 
	                                       prestazione di servizi di telecomunicazioni, tele-radiodiffusione ed elettronici 
	                                       ex art. 7-sexies lett. f, g, art. 74-sexies DPR 633/72)
                       </xs:documentation></xs:annotation>
      </xs:enumeration>
    </xs:restriction>
  </xs:simpleType>

  <xs:simpleType name="DeducibileType">
    <xs:restriction base="xs:string">
      <xs:length value="2" />
      <xs:enumeration value="SI">
        <xs:annotation><xs:documentation>Spesa deducibile</xs:documentation></xs:annotation>
      </xs:enumeration>
    </xs:restriction>
  </xs:simpleType>
  
  
  <xs:simpleType name="EsigibilitaIVAType">
    <xs:restriction base="xs:string">
      <xs:minLength value="1" />
      <xs:maxLength value="1" />
      <xs:enumeration value="D">
        <xs:annotation>
          <xs:documentation>esigibilità differita</xs:documentation>
        </xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="I">
        <xs:annotation>
          <xs:documentation>esigibilità immediata</xs:documentation>
        </xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="S">
        <xs:annotation>
          <xs:documentation>scissione dei pagamenti</xs:documentation>
        </xs:annotation>
      </xs:enumeration>
    </xs:restriction>
  </xs:simpleType>
  
   <xs:simpleType name="RateType">
    <xs:restriction base="xs:decimal">
      <xs:maxInclusive value="100.00" />
      <xs:pattern value="[0-9]{1,3}\.[0-9]{2}" />
      <xs:whiteSpace value="collapse"/>
    </xs:restriction>
  </xs:simpleType>  
  
  <!-- NUMERI -->
  <xs:simpleType name="Amount2DecimalType">
    <xs:restriction base="xs:decimal">
      <xs:pattern value="[\-]?[0-9]{1,11}\.[0-9]{2}" />
      <xs:whiteSpace value="collapse"/>
    </xs:restriction>
  </xs:simpleType>
  
</xs:schema>')
insert #tA values ('14', 'DatiFatturaCorrv1.0', '<?xml version="1.0" encoding="utf-8"?>
<xs:schema xmlns:xs="http://www.w3.org/2001/XMLSchema" 
	xmlns:ds="http://www.w3.org/2000/09/xmldsig#" 
	xmlns="http://ivaservizi.agenziaentrate.gov.it/docs/xsd/fatture/v2.0" 
	targetNamespace="http://ivaservizi.agenziaentrate.gov.it/docs/xsd/fatture/v2.0" 
	version="2.1">

  <xs:import namespace="http://www.w3.org/2000/09/xmldsig#" schemaLocation="http://www.w3.org/TR/2002/REC-xmldsig-core-20020212/xmldsig-core-schema.xsd" />
    
  <!-- =================================================================== -->
  <!-- ELEMENTI                                                            -->
  <!-- =================================================================== -->
  <xs:element name="DatiFattura" type="DatiFatturaType">
    <xs:annotation>
      <xs:documentation>XML schema fatture emesse e ricevute ex D.Lgs. 127/205 (art.1, c.3) 2.1</xs:documentation>
    </xs:annotation>
  </xs:element>  
  
  <!-- =================================================================== -->
  <!-- TIPI                                                                -->
  <!-- =================================================================== -->
  <xs:complexType name="DatiFatturaType">
    <xs:sequence>
      <xs:element name="DatiFatturaHeader"    type="DatiFatturaHeaderType"      minOccurs="0" />
	  <xs:choice>
	    <xs:element name="DTE" type="DTEType" />
	    <xs:element name="DTR" type="DTRType" />
	    <xs:element name="ANN" type="ANNType" />
      </xs:choice>
      <xs:element ref ="ds:Signature" minOccurs="0" />
    </xs:sequence>
    <xs:attribute name="versione" type="VersioneType" use="required" />
  </xs:complexType>  
  
  <xs:complexType name="DatiFatturaHeaderType">
    <xs:sequence>
      <xs:element name="ProgressivoInvio" type="String10Type"                minOccurs="0" />
      <xs:element name="Dichiarante"      type="DichiaranteType"             minOccurs="0" />
      <xs:element name="IdSistema"        type="CodiceFiscaleType"           minOccurs="0" />
      <xs:element name="SpazioDatiFattura" type="xs:normalizedString" minOccurs="0" />
    </xs:sequence>
  </xs:complexType>     
  
  <xs:complexType name="DichiaranteType">
    <xs:sequence>
      <xs:element name="CodiceFiscale"             type="CodiceFiscaleType" />
      <xs:element name="Carica"                    type="CaricaType"        />
    </xs:sequence>
  </xs:complexType>  
  
  <xs:complexType name="DTEType">
    <xs:sequence>
      <xs:element name="CedentePrestatoreDTE"      type="CedentePrestatoreDTEType"                                     />
      <xs:element name="CessionarioCommittenteDTE" type="CessionarioCommittenteDTEType" minOccurs="1" maxOccurs="1000" />
      <xs:element name="Rettifica"                 type="RettificaType"                 minOccurs="0"                  />
    </xs:sequence>
  </xs:complexType>
  
  <xs:complexType name="DTRType">
    <xs:sequence>
      <xs:element name="CessionarioCommittenteDTR" type="CessionarioCommittenteDTRType"                                />
      <xs:element name="CedentePrestatoreDTR"      type="CedentePrestatoreDTRType"      minOccurs="1" maxOccurs="1000" />
      <xs:element name="Rettifica"                 type="RettificaType"                 minOccurs="0"                  />
    </xs:sequence>
  </xs:complexType>
  
  <xs:complexType name="ANNType">
    <xs:sequence>
      <xs:element name="IdFile"                    type="String18Type" />
      <xs:element name="Posizione"                 type="PosizioneType"                 minOccurs="0" />
    </xs:sequence>
  </xs:complexType>  
  
  <xs:complexType name="CedentePrestatoreDTEType">
    <xs:annotation><xs:documentation>Blocco relativo ai dati del Cedente / Prestatore</xs:documentation></xs:annotation>
    <xs:sequence>
      <xs:element name="IdentificativiFiscali"   type="IdentificativiFiscaliITType"               />
      <xs:element name="AltriDatiIdentificativi" type="AltriDatiIdentificativiITType" minOccurs="0" />
    </xs:sequence>   
  </xs:complexType>  
  
  <xs:annotation><xs:documentation>Blocco relativo ai dati del Cedente / Prestatore</xs:documentation></xs:annotation>
  <xs:complexType name="CedentePrestatoreDTRType">
    <xs:sequence>
      <xs:element name="IdentificativiFiscali"   type="IdentificativiFiscaliType"        minOccurs="0"    />
      <xs:element name="AltriDatiIdentificativi" type="AltriDatiIdentificativiType"      minOccurs="0"    />
      <xs:element name="DatiFatturaBodyDTR"      type="DatiFatturaBodyDTRType"           maxOccurs="1000" />
    </xs:sequence>   
  </xs:complexType>  
  
  <xs:complexType name="CessionarioCommittenteDTEType">
    <xs:annotation><xs:documentation>Blocco relativo ai dati del Cessionario / Committente</xs:documentation></xs:annotation>
    <xs:sequence>
      <xs:element name="IdentificativiFiscali"   type="IdentificativiFiscaliNoIVAType"   minOccurs="0"    />
      <xs:element name="AltriDatiIdentificativi" type="AltriDatiIdentificativiType"      minOccurs="0"    />
      <xs:element name="DatiFatturaBodyDTE"      type="DatiFatturaBodyDTEType"           maxOccurs="1000" />
    </xs:sequence>
  </xs:complexType>
    
  <xs:complexType name="CessionarioCommittenteDTRType">
    <xs:annotation><xs:documentation>Blocco relativo ai dati del Cessionario / Committente</xs:documentation></xs:annotation>
    <xs:sequence>
      <xs:element name="IdentificativiFiscali"   type="IdentificativiFiscaliITType"               />
      <xs:element name="AltriDatiIdentificativi" type="AltriDatiIdentificativiITType" minOccurs="0" />
    </xs:sequence>
  </xs:complexType>
    
  <xs:complexType name="DatiFatturaBodyDTEType">
    <xs:sequence>
      <xs:element name="DatiGenerali"  type="DatiGeneraliDTEType"                   />
      <xs:element name="DatiRiepilogo" type="DatiRiepilogoType" maxOccurs="1000"    />
    </xs:sequence>
  </xs:complexType> 
  
  <xs:complexType name="DatiFatturaBodyDTRType">
    <xs:sequence>
      <xs:element name="DatiGenerali"  type="DatiGeneraliDTRType"                  />
      <xs:element name="DatiRiepilogo" type="DatiRiepilogoType"   maxOccurs="1000" />
    </xs:sequence>
  </xs:complexType> 
    
  <xs:complexType name="RettificaType">
    <xs:sequence>
      <xs:element name="IdFile"                    type="String18Type"  />
      <xs:element name="Posizione"                 type="PosizioneType" />
    </xs:sequence>
  </xs:complexType>
  
  <xs:complexType name="IdentificativiFiscaliType">
    <xs:sequence>
      <xs:element name="IdFiscaleIVA"  type="IdFiscaleType"                   />
      <xs:element name="CodiceFiscale" type="CodiceFiscaleType" minOccurs="0" />
    </xs:sequence>
  </xs:complexType>  
  
  <xs:complexType name="IdentificativiFiscaliITType">
    <xs:sequence>
      <xs:element name="IdFiscaleIVA"  type="IdFiscaleITType"                 />
      <xs:element name="CodiceFiscale" type="CodiceFiscaleType" minOccurs="0" />
    </xs:sequence>
  </xs:complexType>  
  
  <xs:complexType name="IdentificativiFiscaliNoIVAType">
    <xs:sequence>
      <xs:element name="IdFiscaleIVA"  type="IdFiscaleType"     minOccurs="0" />
      <xs:element name="CodiceFiscale" type="CodiceFiscaleType" minOccurs="0" />
    </xs:sequence>
  </xs:complexType>      
 
  <xs:complexType name="AltriDatiIdentificativiITType">
    <xs:sequence>
      <xs:element name="Denominazione"         type="String80LatinType"           minOccurs="0" />
      <xs:element name="Nome"                  type="String60LatinType"           minOccurs="0" />
      <xs:element name="Cognome"               type="String60LatinType"           minOccurs="0" />
      <xs:element name="Sede"                  type="IndirizzoType"               minOccurs="0" />
	  <xs:element name="StabileOrganizzazione" type="IndirizzoType"               minOccurs="0" />
	  <xs:element name="RappresentanteFiscale" type="RappresentanteFiscaleITType" minOccurs="0" />
    </xs:sequence>
  </xs:complexType>

  <xs:complexType name="AltriDatiIdentificativiType">
    <xs:sequence>
      <xs:element name="Denominazione"         type="String80LatinType"           minOccurs="0" />
      <xs:element name="Nome"                  type="String60LatinType"           minOccurs="0" />
      <xs:element name="Cognome"               type="String60LatinType"           minOccurs="0" />
      <xs:element name="Sede"                  type="IndirizzoType"               minOccurs="0" />
	  <xs:element name="StabileOrganizzazione" type="IndirizzoType"               minOccurs="0" />
	  <xs:element name="RappresentanteFiscale" type="RappresentanteFiscaleType" minOccurs="0" />
    </xs:sequence>
  </xs:complexType>
     
  <xs:complexType name="IndirizzoType">
    <xs:sequence>
      <xs:element name="Indirizzo"    type="String60LatinType"   minOccurs="0" />
      <xs:element name="NumeroCivico" type="NumeroCivicoType"    minOccurs="0" />
      <xs:element name="CAP"          type="CAPType"             minOccurs="0" />
      <xs:element name="Comune"       type="String60LatinType"   minOccurs="0" />
      <xs:element name="Provincia"    type="ProvinciaType"       minOccurs="0" />
      <xs:element name="Nazione"      type="NazioneType"         minOccurs="0" />
    </xs:sequence>
  </xs:complexType> 
  
  <xs:complexType name="RappresentanteFiscaleType">
    <xs:sequence>
      <xs:element name="IdFiscaleIVA"  type="IdFiscaleType"      minOccurs="0" /> 
      <xs:element name="Denominazione" type="String80LatinType"  minOccurs="0" />
      <xs:element name="Nome"          type="String60LatinType"  minOccurs="0" />
      <xs:element name="Cognome"       type="String60LatinType"  minOccurs="0" />
    </xs:sequence>
  </xs:complexType>  
  
  <xs:complexType name="RappresentanteFiscaleITType">
    <xs:sequence>
      <xs:element name="IdFiscaleIVA"  type="IdFiscaleITType"    minOccurs="0" /> 
      <xs:element name="Denominazione" type="String80LatinType"  minOccurs="0" />
      <xs:element name="Nome"          type="String60LatinType"  minOccurs="0" />
      <xs:element name="Cognome"       type="String60LatinType"  minOccurs="0" />
    </xs:sequence>
  </xs:complexType>  
  
  <xs:complexType name="DatiGeneraliDTEType">
    <xs:sequence>
      <xs:element name="TipoDocumento" type="TipoDocumentoType"  />
      <xs:element name="Data"          type="DataFatturaType"    />
      <xs:element name="Numero"        type="String20Type"       />
    </xs:sequence>
  </xs:complexType>    
  
  <xs:complexType name="DatiGeneraliDTRType">
    <xs:sequence>
      <xs:element name="TipoDocumento"     type="TipoDocumentoType"               />
      <xs:element name="Data"              type="DataFatturaType"   minOccurs="0" />
      <xs:element name="Numero"            type="String20Type"                    />
      <xs:element name="DataRegistrazione" type="DataFatturaType"                 />
    </xs:sequence>
  </xs:complexType>    
  
  <xs:complexType name="DatiRiepilogoType">
    <xs:sequence>
      <xs:element name="ImponibileImporto" type="Amount2DecimalType"                  />
      <xs:element name="DatiIVA"           type="DatiIVAType"                         />
      <xs:element name="Natura"            type="NaturaType"            minOccurs="0" />
      <xs:element name="Detraibile"        type="RateType"              minOccurs="0" />
      <xs:element name="Deducibile"        type="DeducibileType"        minOccurs="0" />
      <xs:element name="EsigibilitaIVA"    type="EsigibilitaIVAType"    minOccurs="0" />
    </xs:sequence>
  </xs:complexType>  
  
  <xs:complexType name="DatiIVAType">
    <xs:sequence>
      <xs:element name="Imposta"  type="Amount2DecimalType" minOccurs="0" />
      <xs:element name="Aliquota" type="RateType"           minOccurs="0" />
    </xs:sequence>
  </xs:complexType> 
    
  <xs:complexType name="IdFiscaleType">
	<xs:sequence>
	  <xs:element name="IdPaese"  type="NazioneType" />
	  <xs:element name="IdCodice" type="CodiceType"  />
	</xs:sequence>
  </xs:complexType>
    
  <xs:complexType name="IdFiscaleITType">
	<xs:sequence>
	  <xs:element name="IdPaese"  type="NazioneITType" />
	  <xs:element name="IdCodice" type="CodiceIvaType" />
	</xs:sequence>
  </xs:complexType>

  <xs:simpleType name="CodiceFiscaleType">
    <xs:restriction base="xs:normalizedString">
      <xs:pattern value="[A-Z0-9]{11,16}" />
    </xs:restriction>
  </xs:simpleType>
  
  <xs:simpleType name="NazioneType">
    <xs:restriction base="xs:string">
      <xs:pattern value="[A-Z]{2}" />
    </xs:restriction>
  </xs:simpleType>
  
  <xs:simpleType name="NazioneITType">
    <xs:restriction base="xs:string">
      <xs:length value="2" />
      <xs:enumeration value="IT">
        <xs:annotation><xs:documentation>Italia</xs:documentation></xs:annotation>
      </xs:enumeration>
    </xs:restriction>
  </xs:simpleType>

  <xs:simpleType name="CodiceType">
    <xs:restriction base="xs:normalizedString">
      <xs:minLength value="1" />
      <xs:maxLength value="28" />
    </xs:restriction>
  </xs:simpleType>

  <xs:simpleType name="CodiceIvaType">
    <xs:restriction base="xs:normalizedString">
      <xs:minLength value="1" />
      <xs:maxLength value="11" />
    </xs:restriction>
  </xs:simpleType>  
  
  <xs:simpleType name="NumeroCivicoType">
    <xs:restriction base="xs:normalizedString">
      <xs:pattern value="(\p{IsBasicLatin}{1,8})" />
    </xs:restriction>
  </xs:simpleType>

  <xs:simpleType name="CAPType">
    <xs:restriction base="xs:normalizedString">
      <xs:pattern value="(\p{IsBasicLatin}{1,5})" />
    </xs:restriction>
  </xs:simpleType>

  <xs:simpleType name="ProvinciaType">
    <xs:restriction base="xs:string">
      <xs:pattern value="[A-Z]{2}" />
    </xs:restriction>
  </xs:simpleType>
  
  <xs:simpleType name="TipoDocumentoType">
    <xs:restriction base="xs:string">
      <xs:length value="4" />
      <xs:enumeration value="TD01">
        <xs:annotation><xs:documentation>Fattura</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="TD04">
        <xs:annotation><xs:documentation>Nota di credito</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="TD05">
        <xs:annotation><xs:documentation>Nota di debito</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="TD07">
        <xs:annotation><xs:documentation>Fattura semplificata</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="TD08">
        <xs:annotation><xs:documentation>Nota di credito semplificata</xs:documentation></xs:annotation>
      </xs:enumeration>
	  <xs:enumeration value="TD10">
        <xs:annotation><xs:documentation>Acquisto beni intra</xs:documentation></xs:annotation>
      </xs:enumeration>
	  <xs:enumeration value="TD11">
        <xs:annotation><xs:documentation>Acquisto servizi intra</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="TD12">
        <xs:annotation><xs:documentation>Documento riepilogativo (art. 6, DPR 695/1996)</xs:documentation></xs:annotation>
      </xs:enumeration>
    </xs:restriction>
  </xs:simpleType>
  
  <xs:simpleType name="DataFatturaType">
    <xs:restriction base="xs:date">
      <xs:minInclusive value="1970-01-01" />
      <xs:whiteSpace value="collapse"/>
    </xs:restriction>
  </xs:simpleType>
  
  <xs:simpleType name="PosizioneType">
    <xs:restriction base="xs:integer">
      <xs:minInclusive value="1" />
      <xs:maxInclusive value="9999999" />
      <xs:whiteSpace value="collapse"/>
    </xs:restriction>
  </xs:simpleType>  
  
  <xs:simpleType name="CaricaType">
    <xs:restriction base="xs:integer">
      <xs:minInclusive value="1" />
      <xs:maxInclusive value="15" />
      <xs:whiteSpace value="collapse"/>
    </xs:restriction>
  </xs:simpleType>  
  
  <!-- STRINGHE -->
  <xs:simpleType name="String10Type">
    <xs:restriction base="xs:normalizedString">
      <xs:pattern value="(\p{IsBasicLatin}{1,10})" />
    </xs:restriction>
  </xs:simpleType>
  
  <xs:simpleType name="String18Type">
    <xs:restriction base="xs:normalizedString">
      <xs:pattern value="(\p{IsBasicLatin}{1,18})" />
    </xs:restriction>
  </xs:simpleType>
  
  <xs:simpleType name="String20Type">
    <xs:restriction base="xs:normalizedString">
      <xs:pattern value="(\p{IsBasicLatin}{1,20})" />
    </xs:restriction>
  </xs:simpleType>
    
  <xs:simpleType name="String60LatinType">
    <xs:restriction base="xs:normalizedString">
      <xs:pattern value="[\p{IsBasicLatin}\p{IsLatin-1Supplement}]{1,60}" />
    </xs:restriction>
  </xs:simpleType>

  <xs:simpleType name="String80LatinType">
    <xs:restriction base="xs:normalizedString">
      <xs:pattern value="[\p{IsBasicLatin}\p{IsLatin-1Supplement}]{1,80}" />
    </xs:restriction>
  </xs:simpleType>
  
  <xs:simpleType name="VersioneType">
    <xs:restriction base="xs:string">
      <xs:length value="5" />      
	  <xs:enumeration value="DAT20">
	    <xs:annotation><xs:documentation>Dati fatture versione 2.1</xs:documentation></xs:annotation>
	  </xs:enumeration>
    </xs:restriction>
  </xs:simpleType>
  
  <xs:simpleType name="NaturaType">
    <xs:restriction base="xs:string">
      <xs:enumeration value="N1">
        <xs:annotation><xs:documentation>Escluse ex. art. 15</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="N2">
        <xs:annotation><xs:documentation>Non soggette</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="N3">
        <xs:annotation><xs:documentation>Non Imponibili</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="N4">
        <xs:annotation><xs:documentation>Esenti</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="N5">
        <xs:annotation><xs:documentation>Regime del margine</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="N6">
        <xs:annotation><xs:documentation>Inversione contabile (reverse charge)</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="N7">
        <xs:annotation>
                       <xs:documentation> IVA assolta in altro stato UE
	                                      (vendite a distanza ex art. 40 c. 3 e 4 e art. 41 c. 1 lett. b,  DL 331/93; 
	                                       prestazione di servizi di telecomunicazioni, tele-radiodiffusione ed elettronici 
	                                       ex art. 7-sexies lett. f, g, art. 74-sexies DPR 633/72)
                       </xs:documentation></xs:annotation>
      </xs:enumeration>
    </xs:restriction>
  </xs:simpleType>

  <xs:simpleType name="DeducibileType">
    <xs:restriction base="xs:string">
      <xs:length value="2" />
      <xs:enumeration value="SI">
        <xs:annotation><xs:documentation>Spesa deducibile</xs:documentation></xs:annotation>
      </xs:enumeration>
    </xs:restriction>
  </xs:simpleType>
  
  
  <xs:simpleType name="EsigibilitaIVAType">
    <xs:restriction base="xs:string">
      <xs:minLength value="1" />
      <xs:maxLength value="1" />
      <xs:enumeration value="D">
        <xs:annotation>
          <xs:documentation>esigibilità differita</xs:documentation>
        </xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="I">
        <xs:annotation>
          <xs:documentation>esigibilità immediata</xs:documentation>
        </xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="S">
        <xs:annotation>
          <xs:documentation>scissione dei pagamenti</xs:documentation>
        </xs:annotation>
      </xs:enumeration>
    </xs:restriction>
  </xs:simpleType>
  
   <xs:simpleType name="RateType">
    <xs:restriction base="xs:decimal">
      <xs:maxInclusive value="100.00" />
      <xs:pattern value="[0-9]{1,3}\.[0-9]{2}" />
      <xs:whiteSpace value="collapse"/>
    </xs:restriction>
  </xs:simpleType>  
  
  <!-- NUMERI -->
  <xs:simpleType name="Amount2DecimalType">
    <xs:restriction base="xs:decimal">
      <xs:pattern value="[\-]?[0-9]{1,11}\.[0-9]{2}" />
      <xs:whiteSpace value="collapse"/>
    </xs:restriction>
  </xs:simpleType>
  
</xs:schema>')
 insert #tA values ('15', 'DatiFatturav2.1', '<?xml version="1.0" encoding="utf-8"?>
<xs:schema xmlns:xs="http://www.w3.org/2001/XMLSchema" 
	xmlns:ds="http://www.w3.org/2000/09/xmldsig#" 
	xmlns="http://ivaservizi.agenziaentrate.gov.it/docs/xsd/fatture/v2.0" 
	targetNamespace="http://ivaservizi.agenziaentrate.gov.it/docs/xsd/fatture/v2.0" 
	version="2.1.1">

  <xs:import namespace="http://www.w3.org/2000/09/xmldsig#" schemaLocation="http://www.w3.org/TR/2002/REC-xmldsig-core-20020212/xmldsig-core-schema.xsd" />
  
    
  <!-- =================================================================== -->
  <!-- ELEMENTI                                                            -->
  <!-- =================================================================== -->
  <xs:element name="DatiFattura" type="DatiFatturaType">
    <xs:annotation>
      <xs:documentation>XML schema fatture emesse e ricevute ex D.Lgs. 127/205 (art.1, c.3) 2.1.1</xs:documentation>
    </xs:annotation>
  </xs:element>  
  
  <!-- =================================================================== -->
  <!-- TIPI                                                                -->
  <!-- =================================================================== -->
  <xs:complexType name="DatiFatturaType">
    <xs:sequence>
      <xs:element name="DatiFatturaHeader"    type="DatiFatturaHeaderType"      minOccurs="0" />
	  <xs:choice>
	    <xs:element name="DTE" type="DTEType" />
	    <xs:element name="DTR" type="DTRType" />
	    <xs:element name="ANN" type="ANNType" />
      </xs:choice>
      <xs:element ref ="ds:Signature" minOccurs="0" />
    </xs:sequence>
    <xs:attribute name="versione" type="VersioneType" use="required" />
  </xs:complexType>  
  
  <xs:complexType name="DatiFatturaHeaderType">
    <xs:sequence>
      <xs:element name="ProgressivoInvio" type="String10Type"                minOccurs="0" />
      <xs:element name="Dichiarante"      type="DichiaranteType"             minOccurs="0" />
      <xs:element name="IdSistema"        type="CodiceFiscaleType"           minOccurs="0" />
      <xs:element name="SpazioDatiFattura" type="xs:normalizedString" minOccurs="0" />
    </xs:sequence>
  </xs:complexType>     
  
  <xs:complexType name="DichiaranteType">
    <xs:sequence>
      <xs:element name="CodiceFiscale"             type="CodiceFiscaleType" />
      <xs:element name="Carica"                    type="CaricaType"        />
    </xs:sequence>
  </xs:complexType>  
  
  <xs:complexType name="DTEType">
    <xs:sequence>
      <xs:element name="CedentePrestatoreDTE"      type="CedentePrestatoreDTEType"                                     />
      <xs:element name="CessionarioCommittenteDTE" type="CessionarioCommittenteDTEType" minOccurs="1" maxOccurs="1000" />
      <xs:element name="Rettifica"                 type="RettificaType"                 minOccurs="0"                  />
    </xs:sequence>
  </xs:complexType>
  
  <xs:complexType name="DTRType">
    <xs:sequence>
      <xs:element name="CessionarioCommittenteDTR" type="CessionarioCommittenteDTRType"                                />
      <xs:element name="CedentePrestatoreDTR"      type="CedentePrestatoreDTRType"      minOccurs="1" maxOccurs="1000" />
      <xs:element name="Rettifica"                 type="RettificaType"                 minOccurs="0"                  />
    </xs:sequence>
  </xs:complexType>
  
  <xs:complexType name="ANNType">
    <xs:sequence>
      <xs:element name="IdFile"                    type="String18Type" />
      <xs:element name="Posizione"                 type="PosizioneType"                 minOccurs="0" />
    </xs:sequence>
  </xs:complexType>  
  
  <xs:complexType name="CedentePrestatoreDTEType">
    <xs:annotation><xs:documentation>Blocco relativo ai dati del Cedente / Prestatore</xs:documentation></xs:annotation>
    <xs:sequence>
      <xs:element name="IdentificativiFiscali"   type="IdentificativiFiscaliITType"               />
      <xs:element name="AltriDatiIdentificativi" type="AltriDatiIdentificativiITType" minOccurs="0" />
    </xs:sequence>   
  </xs:complexType>  
  
  <xs:annotation><xs:documentation>Blocco relativo ai dati del Cedente / Prestatore</xs:documentation></xs:annotation>
  <xs:complexType name="CedentePrestatoreDTRType">
    <xs:sequence>
      <xs:element name="IdentificativiFiscali"   type="IdentificativiFiscaliType"        minOccurs="0"    />
      <xs:element name="AltriDatiIdentificativi" type="AltriDatiIdentificativiType"      minOccurs="0"    />
      <xs:element name="DatiFatturaBodyDTR"      type="DatiFatturaBodyDTRType"           maxOccurs="1000" />
    </xs:sequence>   
  </xs:complexType>  
  
  <xs:complexType name="CessionarioCommittenteDTEType">
    <xs:annotation><xs:documentation>Blocco relativo ai dati del Cessionario / Committente</xs:documentation></xs:annotation>
    <xs:sequence>
      <xs:element name="IdentificativiFiscali"   type="IdentificativiFiscaliNoIVAType"   minOccurs="0"    />
      <xs:element name="AltriDatiIdentificativi" type="AltriDatiIdentificativiType"      minOccurs="0"    />
      <xs:element name="DatiFatturaBodyDTE"      type="DatiFatturaBodyDTEType"           maxOccurs="1000" />
    </xs:sequence>
  </xs:complexType>
    
  <xs:complexType name="CessionarioCommittenteDTRType">
    <xs:annotation><xs:documentation>Blocco relativo ai dati del Cessionario / Committente</xs:documentation></xs:annotation>
    <xs:sequence>
      <xs:element name="IdentificativiFiscali"   type="IdentificativiFiscaliITType"               />
      <xs:element name="AltriDatiIdentificativi" type="AltriDatiIdentificativiITType" minOccurs="0" />
    </xs:sequence>
  </xs:complexType>
    
  <xs:complexType name="DatiFatturaBodyDTEType">
    <xs:sequence>
      <xs:element name="DatiGenerali"  type="DatiGeneraliDTEType"                   />
      <xs:element name="DatiRiepilogo" type="DatiRiepilogoType" maxOccurs="1000"    />
    </xs:sequence>
  </xs:complexType> 
  
  <xs:complexType name="DatiFatturaBodyDTRType">
    <xs:sequence>
      <xs:element name="DatiGenerali"  type="DatiGeneraliDTRType"                  />
      <xs:element name="DatiRiepilogo" type="DatiRiepilogoType"   maxOccurs="1000" />
    </xs:sequence>
  </xs:complexType> 
    
  <xs:complexType name="RettificaType">
    <xs:sequence>
      <xs:element name="IdFile"                    type="String18Type"  />
      <xs:element name="Posizione"                 type="PosizioneType" />
    </xs:sequence>
  </xs:complexType>
  
  <xs:complexType name="IdentificativiFiscaliType">
    <xs:sequence>
      <xs:element name="IdFiscaleIVA"  type="IdFiscaleType"                   />
      <xs:element name="CodiceFiscale" type="CodiceFiscaleType" minOccurs="0" />
    </xs:sequence>
  </xs:complexType>  
  
  <xs:complexType name="IdentificativiFiscaliITType">
    <xs:sequence>
      <xs:element name="IdFiscaleIVA"  type="IdFiscaleITType"                 />
      <xs:element name="CodiceFiscale" type="CodiceFiscaleType" minOccurs="0" />
    </xs:sequence>
  </xs:complexType>  
  
  <xs:complexType name="IdentificativiFiscaliNoIVAType">
    <xs:sequence>
      <xs:element name="IdFiscaleIVA"  type="IdFiscaleType"     minOccurs="0" />
      <xs:element name="CodiceFiscale" type="CodiceFiscaleType" minOccurs="0" />
    </xs:sequence>
  </xs:complexType>      
 
  <xs:complexType name="AltriDatiIdentificativiITType">
    <xs:sequence>
      <xs:element name="Denominazione"         type="String80LatinType"           minOccurs="0" />
      <xs:element name="Nome"                  type="String60LatinType"           minOccurs="0" />
      <xs:element name="Cognome"               type="String60LatinType"           minOccurs="0" />
      <xs:element name="Sede"                  type="IndirizzoType"               minOccurs="0" />
	  <xs:element name="StabileOrganizzazione" type="IndirizzoType"               minOccurs="0" />
	  <xs:element name="RappresentanteFiscale" type="RappresentanteFiscaleITType" minOccurs="0" />
    </xs:sequence>
  </xs:complexType>

  <xs:complexType name="AltriDatiIdentificativiType">
    <xs:sequence>
      <xs:element name="Denominazione"         type="String80LatinType"           minOccurs="0" />
      <xs:element name="Nome"                  type="String60LatinType"           minOccurs="0" />
      <xs:element name="Cognome"               type="String60LatinType"           minOccurs="0" />
      <xs:element name="Sede"                  type="IndirizzoType"               minOccurs="0" />
	  <xs:element name="StabileOrganizzazione" type="IndirizzoType"               minOccurs="0" />
	  <xs:element name="RappresentanteFiscale" type="RappresentanteFiscaleType" minOccurs="0" />
    </xs:sequence>
  </xs:complexType>
     
  <xs:complexType name="IndirizzoType">
    <xs:sequence>
      <xs:element name="Indirizzo"    type="String60LatinType"   minOccurs="0" />
      <xs:element name="NumeroCivico" type="NumeroCivicoType"    minOccurs="0" />
      <xs:element name="CAP"          type="CAPType"             minOccurs="0" />
      <xs:element name="Comune"       type="String60LatinType"   minOccurs="0" />
      <xs:element name="Provincia"    type="ProvinciaType"       minOccurs="0" />
      <xs:element name="Nazione"      type="NazioneType"         minOccurs="0" />
    </xs:sequence>
  </xs:complexType> 
  
  <xs:complexType name="RappresentanteFiscaleType">
    <xs:sequence>
      <xs:element name="IdFiscaleIVA"  type="IdFiscaleType"      minOccurs="0" /> 
      <xs:element name="Denominazione" type="String80LatinType"  minOccurs="0" />
      <xs:element name="Nome"          type="String60LatinType"  minOccurs="0" />
      <xs:element name="Cognome"       type="String60LatinType"  minOccurs="0" />
    </xs:sequence>
  </xs:complexType>  
  
  <xs:complexType name="RappresentanteFiscaleITType">
    <xs:sequence>
      <xs:element name="IdFiscaleIVA"  type="IdFiscaleITType"    minOccurs="0" /> 
      <xs:element name="Denominazione" type="String80LatinType"  minOccurs="0" />
      <xs:element name="Nome"          type="String60LatinType"  minOccurs="0" />
      <xs:element name="Cognome"       type="String60LatinType"  minOccurs="0" />
    </xs:sequence>
  </xs:complexType>  
  
  <xs:complexType name="DatiGeneraliDTEType">
    <xs:sequence>
      <xs:element name="TipoDocumento" type="TipoDocumentoType"  />
      <xs:element name="Data"          type="DataFatturaType"    />
      <xs:element name="Numero"        type="String20Type"       />
    </xs:sequence>
  </xs:complexType>    
  
  <xs:complexType name="DatiGeneraliDTRType">
    <xs:sequence>
      <xs:element name="TipoDocumento"     type="TipoDocumentoType"               />
      <xs:element name="Data"              type="DataFatturaType"   minOccurs="0" />
      <xs:element name="Numero"            type="String20Type"                    />
      <xs:element name="DataRegistrazione" type="DataFatturaType"                 />
    </xs:sequence>
  </xs:complexType>    
  
  <xs:complexType name="DatiRiepilogoType">
    <xs:sequence>
      <xs:element name="ImponibileImporto" type="Amount2DecimalType"                  />
      <xs:element name="DatiIVA"           type="DatiIVAType"                         />
      <xs:element name="Natura"            type="NaturaType"            minOccurs="0" />
      <xs:element name="Detraibile"        type="RateType"              minOccurs="0" />
      <xs:element name="Deducibile"        type="DeducibileType"        minOccurs="0" />
      <xs:element name="EsigibilitaIVA"    type="EsigibilitaIVAType"    minOccurs="0" />
    </xs:sequence>
  </xs:complexType>  
  
  <xs:complexType name="DatiIVAType">
    <xs:sequence>
      <xs:element name="Imposta"  type="Amount2DecimalType" minOccurs="0" />
      <xs:element name="Aliquota" type="RateType"           minOccurs="0" />
    </xs:sequence>
  </xs:complexType> 
    
  <xs:complexType name="IdFiscaleType">
	<xs:sequence>
	  <xs:element name="IdPaese"  type="NazioneType" />
	  <xs:element name="IdCodice" type="CodiceType"  />
	</xs:sequence>
  </xs:complexType>
    
  <xs:complexType name="IdFiscaleITType">
	<xs:sequence>
	  <xs:element name="IdPaese"  type="NazioneITType" />
	  <xs:element name="IdCodice" type="CodiceIvaType" />
	</xs:sequence>
  </xs:complexType>

  <xs:simpleType name="CodiceFiscaleType">
    <xs:restriction base="xs:normalizedString">
      <xs:pattern value="[A-Z0-9]{11,16}" />
    </xs:restriction>
  </xs:simpleType>
  
  <xs:simpleType name="NazioneType">
    <xs:restriction base="xs:string">
      <xs:pattern value="[A-Z]{2}" />
    </xs:restriction>
  </xs:simpleType>
  
  <xs:simpleType name="NazioneITType">
    <xs:restriction base="xs:string">
      <xs:length value="2" />
      <xs:enumeration value="IT">
        <xs:annotation><xs:documentation>Italia</xs:documentation></xs:annotation>
      </xs:enumeration>
    </xs:restriction>
  </xs:simpleType>

  <xs:simpleType name="CodiceType">
    <xs:restriction base="xs:normalizedString">
      <xs:minLength value="1" />
      <xs:maxLength value="28" />
    </xs:restriction>
  </xs:simpleType>

  <xs:simpleType name="CodiceIvaType">
    <xs:restriction base="xs:normalizedString">
      <xs:minLength value="1" />
      <xs:maxLength value="11" />
    </xs:restriction>
  </xs:simpleType>  
  
  <xs:simpleType name="NumeroCivicoType">
    <xs:restriction base="xs:normalizedString">
      <xs:pattern value="(\p{IsBasicLatin}{1,8})" />
    </xs:restriction>
  </xs:simpleType>

  <xs:simpleType name="CAPType">
    <xs:restriction base="xs:normalizedString">
      <xs:pattern value="(\p{IsBasicLatin}{1,5})" />
    </xs:restriction>
  </xs:simpleType>

  <xs:simpleType name="ProvinciaType">
    <xs:restriction base="xs:string">
      <xs:pattern value="[A-Z]{2}" />
    </xs:restriction>
  </xs:simpleType>
  
  <xs:simpleType name="TipoDocumentoType">
    <xs:restriction base="xs:string">
      <xs:length value="4" />
      <xs:enumeration value="TD01">
        <xs:annotation><xs:documentation>Fattura</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="TD04">
        <xs:annotation><xs:documentation>Nota di credito</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="TD05">
        <xs:annotation><xs:documentation>Nota di debito</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="TD07">
        <xs:annotation><xs:documentation>Fattura semplificata</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="TD08">
        <xs:annotation><xs:documentation>Nota di credito semplificata</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="TD10">
        <xs:annotation><xs:documentation>Acquisto beni intra</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="TD11">
        <xs:annotation><xs:documentation>Acquisto servizi intra</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="TD12">
        <xs:annotation><xs:documentation>Documento riepilogativo (art. 6, DPR 695/1996)</xs:documentation></xs:annotation>
      </xs:enumeration>
    </xs:restriction>
  </xs:simpleType>
  
  <xs:simpleType name="DataFatturaType">
    <xs:restriction base="xs:date">
      <xs:minInclusive value="1970-01-01" />
      <xs:whiteSpace value="collapse"/>
    </xs:restriction>
  </xs:simpleType>
  
  <xs:simpleType name="PosizioneType">
    <xs:restriction base="xs:integer">
      <xs:minInclusive value="1" />
      <xs:maxInclusive value="9999999" />
      <xs:whiteSpace value="collapse"/>
    </xs:restriction>
  </xs:simpleType>  
  
  <xs:simpleType name="CaricaType">
    <xs:restriction base="xs:integer">
      <xs:minInclusive value="1" />
      <xs:maxInclusive value="15" />
      <xs:whiteSpace value="collapse"/>
    </xs:restriction>
  </xs:simpleType>  
  
  <!-- STRINGHE -->
  <xs:simpleType name="String10Type">
    <xs:restriction base="xs:normalizedString">
      <xs:pattern value="(\p{IsBasicLatin}{1,10})" />
    </xs:restriction>
  </xs:simpleType>
  
  <xs:simpleType name="String18Type">
    <xs:restriction base="xs:normalizedString">
      <xs:pattern value="(\p{IsBasicLatin}{1,18})" />
    </xs:restriction>
  </xs:simpleType>
  
  <xs:simpleType name="String20Type">
    <xs:restriction base="xs:normalizedString">
      <xs:pattern value="(\p{IsBasicLatin}{1,20})" />
    </xs:restriction>
  </xs:simpleType>
    
  <xs:simpleType name="String60LatinType">
    <xs:restriction base="xs:normalizedString">
      <xs:pattern value="[\p{IsBasicLatin}\p{IsLatin-1Supplement}]{1,60}" />
    </xs:restriction>
  </xs:simpleType>

  <xs:simpleType name="String80LatinType">
    <xs:restriction base="xs:normalizedString">
      <xs:pattern value="[\p{IsBasicLatin}\p{IsLatin-1Supplement}]{1,80}" />
    </xs:restriction>
  </xs:simpleType>
  
  <xs:simpleType name="VersioneType">
    <xs:restriction base="xs:string">
      <xs:length value="5" />      
	  <xs:enumeration value="DAT20">
	    <xs:annotation><xs:documentation>Dati fatture versione 2.1</xs:documentation></xs:annotation>
	  </xs:enumeration>
    </xs:restriction>
  </xs:simpleType>
  
  <xs:simpleType name="NaturaType">
    <xs:restriction base="xs:string">
      <xs:enumeration value="N1">
        <xs:annotation><xs:documentation>Escluse ex. art. 15</xs:documentation></xs:annotation>
      </xs:enumeration>
<!-- IL CODICE SEGUENTE (N2) NON SARA'' PIU'' VALIDO A PARTIRE DAL PRIMO GENNAIO 2021-->
      <xs:enumeration value="N2">
        <xs:annotation>
          <xs:documentation>Non soggette</xs:documentation>
        </xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="N2.1">
        <xs:annotation>
          <xs:documentation>Non soggette ad IVA ai sensi degli artt. da 7 a 7-septies del DPR 633/72</xs:documentation>
        </xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="N2.2">
        <xs:annotation>
          <xs:documentation>Non soggette - altri casi</xs:documentation>
        </xs:annotation>
      </xs:enumeration>
<!-- IL CODICE SEGUENTE (N3) NON SARA'' PIU'' VALIDO A PARTIRE DAL PRIMO GENNAIO 2021-->
      <xs:enumeration value="N3">
        <xs:annotation>
          <xs:documentation>Non imponibili</xs:documentation>
        </xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="N3.1">
        <xs:annotation>
          <xs:documentation>Non Imponibili - esportazioni</xs:documentation>
        </xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="N3.2">
        <xs:annotation>
          <xs:documentation>Non Imponibili - cessioni intracomunitarie</xs:documentation>
        </xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="N3.3">
        <xs:annotation>
          <xs:documentation>Non Imponibili - cessioni verso San Marino</xs:documentation>
        </xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="N3.4">
        <xs:annotation>
          <xs:documentation>Non Imponibili - operazioni assimilate alle cessioni all�esportazione</xs:documentation>
        </xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="N3.5">
        <xs:annotation>
          <xs:documentation>Non Imponibili - a seguito di dichiarazioni d�intento</xs:documentation>
        </xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="N3.6">
        <xs:annotation>
          <xs:documentation>Non Imponibili - altre operazioni che non concorrono alla formazione del plafond</xs:documentation>
        </xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="N4">
        <xs:annotation><xs:documentation>Esenti</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="N5">
        <xs:annotation>
          <xs:documentation>Regime del margine/IVA non esposta in fattura</xs:documentation>
        </xs:annotation>
      </xs:enumeration>
<!-- IL CODICE SEGUENTE (N6) NON SARA'' PIU'' VALIDO A PARTIRE DAL PRIMO GENNAIO 2021-->
      <xs:enumeration value="N6">
        <xs:annotation><xs:documentation>Inversione contabile</xs:documentation></xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="N7">
        <xs:annotation>
          <xs:documentation> IVA assolta in altro stato UE (vendite a distanza ex art. 40 c. 3 e 4 e art. 41 c. 1 lett. b,  DL 331/93; 
                             prestazione di servizi di telecomunicazioni, tele-radiodiffusione ed elettronici 
                             ex art. 7-sexies lett. f, g, art. 74-sexies DPR 633/72)
          </xs:documentation>
        </xs:annotation>
      </xs:enumeration>
    </xs:restriction>
  </xs:simpleType>
  <xs:simpleType name="DeducibileType">
    <xs:restriction base="xs:string">
      <xs:length value="2" />
      <xs:enumeration value="SI">
        <xs:annotation><xs:documentation>Spesa deducibile</xs:documentation></xs:annotation>
      </xs:enumeration>
    </xs:restriction>
  </xs:simpleType>
  <xs:simpleType name="EsigibilitaIVAType">
    <xs:restriction base="xs:string">
      <xs:minLength value="1" />
      <xs:maxLength value="1" />
      <xs:enumeration value="D">
        <xs:annotation>
          <xs:documentation>esigibilit� differita</xs:documentation>
        </xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="I">
        <xs:annotation>
          <xs:documentation>esigibilit� immediata</xs:documentation>
        </xs:annotation>
      </xs:enumeration>
      <xs:enumeration value="S">
        <xs:annotation>
          <xs:documentation>scissione dei pagamenti</xs:documentation>
        </xs:annotation>
      </xs:enumeration>
    </xs:restriction>
  </xs:simpleType>
  <xs:simpleType name="RateType">
    <xs:restriction base="xs:decimal">
      <xs:maxInclusive value="100.00" />
      <xs:pattern value="[0-9]{1,3}\.[0-9]{2}" />
      <xs:whiteSpace value="collapse"/>
    </xs:restriction>
  </xs:simpleType>  
  <!-- NUMERI -->
  <xs:simpleType name="Amount2DecimalType">
    <xs:restriction base="xs:decimal">
      <xs:pattern value="[\-]?[0-9]{1,11}\.[0-9]{2}" />
      <xs:whiteSpace value="collapse"/>
    </xs:restriction>
  </xs:simpleType>
</xs:schema>')
  
 MERGE CGX6_SCHEMAXSD AS Target 
 USING(SELECT  CGX6_CODICE, CGX6_NOME, CGX6_XSD FROM #tA) AS source (CGX6_CODICE, CGX6_NOME, CGX6_XSD) 
 ON (target.CGX6_CODICE = source.CGX6_CODICE) 
 WHEN MATCHED 
 THEN 
   UPDATE SET CGX6_NOME = source.CGX6_NOME, CGX6_XSD = source.CGX6_XSD

 WHEN NOT MATCHED 
 THEN 
    INSERT(CGX6_CODICE, CGX6_NOME, CGX6_XSD) 
       VALUES(source.CGX6_CODICE,source.CGX6_NOME,source.CGX6_XSD) ;
 GO 
  IF OBJECT_ID('TEMPDB.DBO.#TA') IS NOT NULL DROP TABLE #TA 
 GO 

 